--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Conditions_Base;

private with Nomo.Numerics.Informations;

private with Nomo.Interpreter.Premises_Index;

private with Nomo.Interpreter.Actuators_Buffers;

private package Nomo.Interpreter.Check_Conditions is

   use Numerics.Times;
   use Conditions_Base;

   type Check_Condition is new Condition_Base with private;

   procedure Evaluate (This  : in out Check_Condition);

   function Get_New_Time_Span (This : in Check_Condition) return Positive_Time_Interval;
   pragma Inline (Get_New_Time_Span);

   function Get_New_Bonus (This : in Check_Condition) return Positive_Time_Interval;
   pragma Inline (Get_New_Bonus);

   function Is_Ongoing (This : in Check_Condition) return Boolean;
   pragma Inline (Is_Ongoing);

   procedure Maximize (This : in out Check_Condition);

   procedure Note (This : in out Check_Condition);

   use Types_Index.Ranges;

   function Are_Possibly_Ongoing (Prediction_Type_Linked : in Prediction_Type_Index) return Boolean;

private

   use Numerics.Informations;
   use Premises_Index.Premises_Index_Instance;
   use Actuators_Buffers;

   type Check_Condition is new Condition_Base with record
      --  Tableau mmorisant les tiquettes temporelles des activateurs
      Candidates             : Actuators_Buffer;
      Landmark_premise       : Premise_Index range 1..Premise_Index'Last;
      Prediction_premise     : Premise_Index range 1..Premise_Index'Last;
      Prediction_Information : Positive_Integer;
      Prediction_Type        : Prediction_Type_Index;
      Ongoing                : Boolean := False;
      New_Time_Span          : Positive_Time_Interval;
      New_Bonus              : Positive_Time_Interval;
   end record;

end Nomo.Interpreter.Check_Conditions;
