--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;
use Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private generic
   type Rule is limited private;
   type Rule_Ptr is access Rule;
   with procedure Reinforce (This : in out Rule;
                             Quantity : in Real_Accurately_0_To_1);
package Nomo.Interpreter.Activations_Memories is


   use Numerics.Times;

   type Activations_Memory is tagged limited private;

   procedure Set_Activation_Last (This          : in out Activations_Memory;
                                  Selected_Rule : not null Rule_Ptr;
                                  T             : in Positive_Time);

   procedure Reinforce (This            : in Activations_Memory;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);

private

   Duration_Limit : constant Positive_Time := Positive_Time (Beginning.Parameters.Get_Time_Span_Limit);

   type Activation is record
      Selected_Rule : Rule_Ptr := null;
      Time          : Numerics.Times.Time := - Duration_Limit;
   end record;

   subtype Activation_Index is Natural range 0 .. Beginning.Parameters.Get_Maximum_Of_Internal_Events - 1;

   type Activations_Trace is array (Activation_Index'Range) of Activation;

   type Activations_Memory is tagged limited record
      Trace           : Activations_Trace;
      Activation_Last : Activation_Index := Activation_Index'First;
   end record;

   Failure : constant Integer := -1;

   Index_Modulo : constant Positive := Beginning.Parameters.Get_Maximum_Of_Internal_Events;
   --  La mmoire des activations est une mmoire circulaire.

end Nomo.Interpreter.Activations_Memories;
