--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Nomo.Numerics.Informations;

private with Nomo.Numerics.Times;

private with Nomo.Numerics.Reals;

private package Nomo.Internal_Messages is

   pragma Pure;

   type Internal_Message is tagged limited private;

private

   use Numerics.Informations;
   use Numerics.Times;
   use Numerics.Reals;

   type Internal_Message is tagged limited record
      Information : Positive_Integer := Positive_Integer'First;
      Time_Span   : Time_Interval := Time_Interval'First; --  ms
      Credibility : Real_0_To_1 := Real_0_To_1'Last;
   end record;

end Nomo.Internal_Messages;
