--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

package Nomo.Internal_Messages.Conclusions.Delayed is

   use Numerics.Times;

   type Delayed_Conclusion is limited new Internal_Conclusion with private;

   function Get_Lateness (This : in Delayed_Conclusion) return Positive_Time;

   package Initialization is

      procedure Initialize (This         : out Delayed_Conclusion;
                            Rule_Storage : in Internal_Conclusion);

   end Initialization;

private

   type Delayed_Conclusion is limited new Internal_Conclusion with record
      Lateness : Positive_Time := 0;
   end record;

end Nomo.Internal_Messages.Conclusions.Delayed;
