--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Internal_Messages.Conclusions.Delayed  is

   function Get_Lateness (This : in Delayed_Conclusion) return Positive_Time is
   begin
      return This.Lateness;
   end Get_Lateness;

   package body Initialization is

      procedure Initialize (This         : out Delayed_Conclusion;
                            Rule_Storage : in Internal_Conclusion) is
      begin
         pragma Assert (Rule_Storage.Time_Span <= 0);
         This.Time_Span := Rule_Storage.Time_Span;
         This.Information := Rule_Storage.Information;
         This.Credibility := 0.0;
         This.Lateness := Positive_Time (- Rule_Storage.Time_Span);
      end Initialize;

   end Initialization;

end Nomo.Internal_Messages.Conclusions.Delayed;
