﻿//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef WORLDSQUAREXML_H
#define WORLDSQUAREXML_H

#include "nomoworldsquare.h"

typedef enum {turn_left  = 0,
              turn_right = 1,
              advance    = 2,
              capture    = 3,
              depose     = 4} commandMotor;

typedef struct {
    float hue[INPUT_HUE_WORLDSQUARE_SIZE];
    float sphere[INPUT_SPHERES_NUMBER_WORLDSQUARE_SIZE];
    float strength[INPUT_STRENGTH_WORLDSQUARE_SIZE];
    float sound[INPUT_SOUND_WORLDSQUARE_SIZE];
    float sonar[INPUT_SONAR_WORLDSQUARE_SIZE];
    float bumper[INPUT_BUMPER_WORLDSQUARE_SIZE];
    float random[INPUT_RANDOM_WORLDSQUARE_SIZE];
} sensors;

int initializeWorldSquareXML (const short agentsNumber);

void readWorldSquareXML (const char* filename);

void saveWorldSquareXML (const char* filename);

sensors getAgentSensorsWorldSquareXML (const short id);

short getAgentNumberActiveWorldSquareXML();

void assumeWorldSquareXML();

void updateInputsWorldSquareXML();

void commandMotorWorldSquareXML (const int delay, const short agent, const commandMotor cmd);

void commandSoundWorldSquareXML (const int delay, const short agent, const int value);

void cleanWorldSquareXML();

#endif // WORLDSQUAREXML_H
