--  Copyright (2008-2011) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Ada.Strings.Unbounded;

package Basic_Sax is

   type Attributes (<>) is private;

   function Get_Quantity (A : in Attributes) return Natural;

   function Get_Name (A     : in Attributes;
                      Index : in Positive) return String;
   --  Lve "NULL_ATTRIBUTE" si l'index est suprieur au nombre d'attributs.

   function Get_Value (A     : in Attributes;
                       Index : in Positive) return String;
   --  Lve "NULL_ATTRIBUTE" si l'index est suprieur au nombre d'attributs.

   NULL_ATTRIBUTE : exception;
   SYNTAXE_ERROR  : exception;

private

   Attributes_Max : constant Natural := 20;
   Size_String_Max : constant Natural := 1000;
   type Attribute is record
      Name  : Ada.Strings.Unbounded.Unbounded_String;
      Value : Ada.Strings.Unbounded.Unbounded_String;
   end record;

   type Tab_Attributes is array(1..Attributes_Max) of Attribute;
   type Attributes is record
      Size : Natural := 0;
      Tab  : Tab_Attributes;
   end record;

end Basic_Sax;
