<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
S'applique sur un programme ou une unité de compilation.
Met à jour les identifiants des models en fonction des dépendances et remplace les programmes redonnant par des éléments "reference".
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:unit="http://www.nomoseed.org/unit" xmlns:plant="http://www.nomoseed.org/plant" xmlns:program="http://www.nomoseed.org/program" xmlns:model="http://www.nomoseed.org/model" xmlns:project="http://www.nomoseed.org/project">
  <xsl:output method="xml" indent="no"/>
  <xsl:template match="program:program">
    <xsl:copy>
      <xsl:attribute name="name">
        <xsl:value-of select="@name"/>
      </xsl:attribute>
      <xsl:if test="@xml:base">
        <xsl:attribute name="xml:base">
          <xsl:value-of select="@xml:base"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:programs | program:body | program:models | program:rules">
    <xsl:copy>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:programs/program:new">
    <xsl:copy>
      <xsl:attribute name="instance">
        <xsl:value-of select="@instance"/>
      </xsl:attribute>
      <xsl:attribute name="programID">
        <xsl:value-of select="@programID"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:programs/program:inherite">
    <xsl:variable name="name" select="program:program/@name"/>
    <xsl:variable name="instance" select="@instance"/>
    <xsl:variable name="instances" select="ancestor::program:program/program:programs/program:*[@instance=$instance]/program:program[@name=$name]"/>
    <xsl:choose>
      <xsl:when test="count($instances)=1">
        <xsl:copy>
          <xsl:attribute name="instance">
            <xsl:value-of select="@instance"/>
          </xsl:attribute>
          <xsl:attribute name="programID">
            <xsl:value-of select="@programID"/>
          </xsl:attribute>
          <xsl:apply-templates/>
        </xsl:copy>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="reference" namespace="http://www.nomoseed.org/program">
          <xsl:attribute name="instance">
            <xsl:value-of select="@instance"/>
          </xsl:attribute>
          <xsl:attribute name="programID">
            <xsl:value-of select="@programID"/>
          </xsl:attribute>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="program:models/program:new">
    <xsl:copy>
      <xsl:attribute name="instance">
        <xsl:value-of select="@instance"/>
      </xsl:attribute>
      <xsl:attribute name="prototype">
        <xsl:value-of select="./model:model/@name"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:value-of select="generate-id(.)"/>
      </xsl:attribute>
      <xsl:attribute name="oldModel">
        <xsl:value-of select="@model"/>
      </xsl:attribute>
      <xsl:apply-templates select="./model:model" mode="recopy">
        <xsl:with-param name="id" select="generate-id(.)"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:models/program:import">
    <xsl:variable name="instance" select="@instance"/>
    <xsl:variable name="program" select="@program"/>
    <xsl:variable name="model">
      <xsl:call-template name="getModelID">
        <xsl:with-param name="program" select="$program"/>
        <xsl:with-param name="instance" select="$instance"/>
        <xsl:with-param name="subprograms" select="../../../program:programs"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:copy>
      <xsl:attribute name="instance">
        <xsl:value-of select="@instance"/>
      </xsl:attribute>
      <xsl:attribute name="program">
        <xsl:value-of select="@program"/>
      </xsl:attribute>
      <xsl:attribute name="prototype">
        <xsl:value-of select="./model:model/@name"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:value-of select="$model"/>
      </xsl:attribute>
      <xsl:attribute name="oldModel">
        <xsl:value-of select="@model"/>
      </xsl:attribute>
      <xsl:attribute name="programID">
        <xsl:value-of select="@programID"/>
      </xsl:attribute>
      <xsl:apply-templates select="model:model" mode="recopy">
        <xsl:with-param name="id" select="$model"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:models/program:inherite[model:model]">
    <xsl:variable name="inherite" select="./model:model/@name"/>
    <xsl:variable name="instance" select="@instance"/>
    <xsl:variable name="model">
        <xsl:variable name="newList" select="./ancestor::program:program/program:body/program:models/program:new[.//model:model/@name=$inherite and @instance=$instance]"/>
        <xsl:choose>
          <xsl:when test="$newList">
            <xsl:value-of select="generate-id($newList[1])"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="generate-id(./ancestor::program:program/program:body/program:models/program:inherite[.//model:model/@name=$inherite and @instance=$instance][last()])"/>
          </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:copy>
      <xsl:attribute name="instance">
        <xsl:value-of select="@instance"/>
      </xsl:attribute>
      <xsl:attribute name="prototype">
        <xsl:value-of select="$inherite"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:value-of select="$model"/>
      </xsl:attribute>
      <xsl:attribute name="oldModel">
        <xsl:value-of select="@model"/>
      </xsl:attribute>
      <xsl:apply-templates select="./model:model" mode="recopy">
        <xsl:with-param name="id" select="$model"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:models/program:inherite[plant:plant_structure]">
    <xsl:variable name="inherite" select="./plant:plant_structure/@name"/>
    <xsl:variable name="list" select="./ancestor::program:program/program:body/program:models/program:inherite[plant:plant_structure/@name=$inherite]"/>
    <xsl:copy>
      <xsl:attribute name="instance">
        <xsl:value-of select="@instance"/>
      </xsl:attribute>
      <xsl:attribute name="prototype">
        <xsl:value-of select="$inherite"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:value-of select="generate-id($list[last()])"/>
      </xsl:attribute>
      <xsl:attribute name="oldModel">
        <xsl:value-of select="@model"/>
      </xsl:attribute>
      <xsl:apply-templates select="./plant:plant_structure" mode="recopy">
        <xsl:with-param name="id" select="generate-id($list[last()])"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*">
    <xsl:copy-of select="."/>
  </xsl:template>
  <xsl:template match="unit:unit">
    <xsl:copy>
      <xsl:attribute name="name">
        <xsl:value-of select="@name"/>
      </xsl:attribute>
      <xsl:attribute name="multiplexer">
        <xsl:value-of select="@multiplexer"/>
      </xsl:attribute>
      <xsl:attribute name="binaryLocation">
        <xsl:value-of select="@binaryLocation"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="plant:plant_structure" mode="recopy">
    <xsl:param name="id"/>
    <xsl:copy>
      <xsl:attribute name="name">
        <xsl:value-of select="$id"/>
      </xsl:attribute>
      <xsl:attribute name="extension">
        <xsl:value-of select="@extension"/>
      </xsl:attribute>
      <xsl:copy-of select="./project:header"/>
      <xsl:apply-templates select="./plant:definition" mode="rename">
        <xsl:with-param name="id" select="$id"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="model:model" mode="recopy">
    <xsl:param name="id"/>
    <xsl:copy>
      <xsl:attribute name="name">
        <xsl:value-of select="$id"/>
      </xsl:attribute>
      <xsl:if test="@xml:base">
        <xsl:attribute name="xml:base">
          <xsl:value-of select="@xml:base"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:copy-of select="./project:header"/>
      <xsl:copy-of select="./model:base"/>
      <xsl:apply-templates select="./model:definition" mode="rename">
        <xsl:with-param name="id" select="$id"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*[.//@model and local-name(.)!='target' and local-name(.)!='information']" mode="rename">
    <xsl:param name="id"/>
    <xsl:copy>
      <xsl:if test="@model and not(@extension)">
        <xsl:attribute name="model">
          <xsl:value-of select="$id"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@type">
        <xsl:attribute name="type">
          <xsl:value-of select="@type"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@extension">
        <xsl:attribute name="extension">
          <xsl:value-of select="@extension"/>
        </xsl:attribute>
        <xsl:attribute name="model">
          <xsl:value-of select="@model"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@in">
        <xsl:attribute name="in">
          <xsl:value-of select="@in"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@base">
        <xsl:attribute name="base">
          <xsl:value-of select="@base"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@name">
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@pos">
        <xsl:attribute name="pos">
          <xsl:value-of select="@pos"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@next">
        <xsl:attribute name="next">
          <xsl:value-of select="@next"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@target">
        <xsl:attribute name="target">
          <xsl:value-of select="@target"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@category">
        <xsl:attribute name="category">
          <xsl:value-of select="@category"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@information_tolerance">
        <xsl:attribute name="information_tolerance">
          <xsl:value-of select="@information_tolerance"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@timespan_tolerance">
        <xsl:attribute name="timespan_tolerance">
          <xsl:value-of select="@timespan_tolerance"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@credibility_tolerance">
        <xsl:attribute name="credibility_tolerance">
          <xsl:value-of select="@credibility_tolerance"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@fitting_nbr">
        <xsl:attribute name="fitting_nbr">
          <xsl:value-of select="@fitting_nbr"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@relevance">
        <xsl:attribute name="relevance">
          <xsl:value-of select="@relevance"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@item">
        <xsl:attribute name="item">
          <xsl:value-of select="@item"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates mode="rename">
        <xsl:with-param name="id" select="$id"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="plant:target" mode="rename">
    <xsl:param name="id"/>
    <xsl:copy>
        <xsl:attribute name="model">
          <xsl:variable name="model" select="normalize-space(@model)" />
          <xsl:choose>
            <xsl:when test="@model = '*'">
              <xsl:value-of select="'*'"/>
            </xsl:when>
            <xsl:when test="contains(@model, ' ')">
              <xsl:value-of select="concat($id, ' plant')"/>
            </xsl:when>
            <xsl:when test="@model = 'plant'">
              <xsl:value-of select="@model"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$id"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="category">
          <xsl:value-of select="@category"/>
        </xsl:attribute>
        <xsl:attribute name="type">
          <xsl:value-of select="@type"/>
        </xsl:attribute>
        <xsl:attribute name="item">
          <xsl:value-of select="@item"/>
        </xsl:attribute>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="plant:information" mode="rename">
    <xsl:param name="id"/>
    <xsl:copy>
        <xsl:attribute name="model">
          <xsl:choose>
            <xsl:when test="contains(@model, 'plant')">
              <xsl:value-of select="'plant'"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$id"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="@value"/>
        </xsl:attribute>
        <xsl:attribute name="type">
          <xsl:value-of select="@type"/>
        </xsl:attribute>
        <xsl:attribute name="item">
          <xsl:value-of select="@item"/>
        </xsl:attribute>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*" mode="rename">
    <xsl:param name="id"/>
    <xsl:copy-of select="."/>
  </xsl:template>
  <xsl:template match="program:*[not(@*)]">
    <xsl:copy>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template name="getModelID">
    <xsl:param name="program"/>
    <xsl:param name="instance"/>
    <xsl:param name="subprograms"/>
      <xsl:choose>
        <xsl:when test="$subprograms/program:new[@instance=$program]">
          <xsl:call-template name="getModelID_1">
            <xsl:with-param name="program" select="$program"/>
            <xsl:with-param name="instance" select="$instance"/>
            <xsl:with-param name="subprograms" select="$subprograms"/>
            <xsl:with-param name="pathProgram" select="$subprograms/program:new[@instance=$program]/program:program/program:body/program:models"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="getModelID_2">
            <xsl:with-param name="program" select="$program"/>
            <xsl:with-param name="instance" select="$instance"/>
            <xsl:with-param name="subprograms" select="$subprograms"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
  </xsl:template>
  <xsl:template name="getModelID_1">
    <xsl:param name="program"/>
    <xsl:param name="instance"/>
    <xsl:param name="subprograms"/>
    <xsl:param name="pathProgram"/>
    <xsl:variable name="importNew" select="$pathProgram/program:new[@instance=$instance]"/>
    <xsl:variable name="importInherite" select="$pathProgram/program:inherite[@instance=$instance]"/>
    <xsl:choose>
      <xsl:when test="$importNew">
       <xsl:value-of select="generate-id($importNew)"/>
      </xsl:when>
      <xsl:when test="not($subprograms)">
       <xsl:value-of select="''"/>
      </xsl:when>
      <xsl:when test="$importInherite">
        <xsl:variable name="inherite" select="$importInherite/model:model/@name" />
        <xsl:variable name="newList" select="$importInherite/ancestor::program:program/program:body/program:models/program:new[.//model:model/@name=$inherite and @instance=$instance]"/>
        <xsl:choose>
          <xsl:when test="$newList">
            <xsl:value-of select="generate-id($newList[1])"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="generate-id($importInherite/ancestor::program:program/program:body/program:models/program:inherite[.//model:model/@name=$inherite and @instance=$instance][last()])"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="getModelID">
        <xsl:with-param name="program" select="$pathProgram/program:import[@instance=$instance]/@program"/>
        <xsl:with-param name="instance" select="$instance"/>
        <xsl:with-param name="subprograms" select="$pathProgram/../../program:programs"/>
      </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:template>
  <xsl:template name="getModelID_2">
    <xsl:param name="program"/>
    <xsl:param name="instance"/>
    <xsl:param name="subprograms"/>
    <xsl:variable name="prototype" select="$subprograms/program:inherite[@instance=$instance]/program:program/@name"/>
    <xsl:variable name="firstNewProgram"  select="$subprograms/program:inherite[@instance=$program]/ancestor::program:program/program:programs/program:new[@instance=$program and ./program:program/@name=$prototype][1]" />
    <xsl:variable name="lastInheriteProgram" select="$subprograms/program:inherite[@instance=$program]/ancestor::program:program/program:programs/program:inherite[@instance=$program and ./program:program/@name=$prototype][last()]" />
    <xsl:choose>
      <xsl:when test="$firstNewProgram">
        <xsl:call-template name="getModelID_1">
          <xsl:with-param name="program" select="$program"/>
          <xsl:with-param name="instance" select="$instance"/>
          <xsl:with-param name="subprograms" select="$subprograms"/>
          <xsl:with-param name="pathProgram" select="$firstNewProgram/program:program/program:body/program:models"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="getModelID_1">
          <xsl:with-param name="program" select="$program"/>
          <xsl:with-param name="instance" select="$instance"/>
          <xsl:with-param name="subprograms" select="$subprograms"/>
          <xsl:with-param name="pathProgram" select="$lastInheriteProgram/program:program/program:body/program:models"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>    
  </xsl:template>
</xsl:stylesheet>
