<?xml version="1.0" encoding="UTF-8"?>
<program xmlns="http://www.nomoseed.org/program" name="agent_base">
  <header xmlns="http://www.nomoseed.org/project">
    <author>Cédric Coussinet (cedric.coussinet@nomoseed.net)</author>
    <copyright>
      <mention xml:lang="en">
        Copyright (2013) Cédric Coussinet
      </mention>
    </copyright>
    <license name="GPLv3">
      <mention xml:lang="en">
        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published
        by the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.
        
        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
        GNU General Public License for more details.
        
        You should have received a copy of the GNU General Public License
        along with this program. If not, see http://www.gnu.org/licenses
      </mention>
    </license>
    <datetime>2014-03-16T13:46:55Z</datetime>
    <version/>
    <annotation>
      <documentation xml:lang="fr">
        Programme correspondant au exemple du tutoriel portant sur les propriétés élémentaires.
      </documentation>
    </annotation>
  </header>
  <subprograms xmlns:xi="http://www.w3.org/2001/XInclude">
    <new instance="exploration">
      <xi:include href="exploration.prg"/>
    </new>
  </subprograms>
  <body>
    <models xmlns:xi="http://www.w3.org/2001/XInclude">
      <new instance="tutorial_5">
        <xi:include href="tutorial_5.mod" parse="xml"/>
      </new>
      <import instance="exploration" subprogram="exploration">
        <xi:include href="exploration.prg#xmlns(model=http://www.nomoseed.org/model)xpointer((//model:model[@name='exploration'])[1])"/>
      </import>
      <new instance="orientation">
        <xi:include href="orientation.mod" parse="xml"/>
      </new>
      <new instance="reaction">
        <xi:include href="reaction.mod" parse="xml"/>
      </new>
    </models>
    <scheme xmlns="http://www.nomoseed.org/program">
      <scheme name="perceptions">
        <scheme name="hue">
          <rule name="hue_1" relevance="0.9">
            <premise model="tutorial_5" category="input" type="hue">
              <information tolerance="2.40000E+02" value="1.80000E+02"/>
            </premise>
            <conclusion model="tutorial_5" category="perception" type="hue">
              <information value="red"/>
            </conclusion>
          </rule>
          <rule name="hue_2" relevance="0.9">
            <premise model="tutorial_5" category="input" type="hue">
              <information tolerance="2.86957E+01" value="1.20858E+02"/>
            </premise>
            <conclusion model="tutorial_5" category="perception" type="hue">
              <information value="green"/>
            </conclusion>
          </rule>
          <rule name="hue_3" relevance="0.9">
            <premise model="tutorial_5" category="input" type="hue">
              <information tolerance="2.86957E+01" value="2.39142E+02"/>
            </premise>
            <conclusion model="tutorial_5" category="perception" type="hue">
              <information value="blue"/>
            </conclusion>
          </rule>
          <rule name="hue_4" relevance="0.9">
            <premise model="tutorial_5" category="input" type="hue">
              <information tolerance="2.86957E+02" value="2.39142E+02"/>
            </premise>
            <conclusion model="tutorial_5" category="perception" type="hue">
              <information value="default"/>
            </conclusion>
          </rule>
        </scheme>
        <rule name="strength">
          <premise model="tutorial_5" category="input" type="strength">
            <information value="1" tolerance="INF"/>
          </premise>
          <conclusion model="tutorial_5" category="perception" type="strength">
            <information value="failed"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="actions">
        <rule name="advance">
          <premise model="tutorial_5" category="conception" type="motor">
            <information value="advance" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_5" category="command" type="motor">
            <information value="advance"/>
            <output value="2"/>
          </conclusion>
        </rule>
        <rule name="turn_left">
          <premise model="tutorial_5" category="conception" type="motor">
            <information value="turn_left" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_5" category="command" type="motor">
            <information value="turn_left"/>
            <output value="0"/>
          </conclusion>
        </rule>
        <rule name="turn_right">
          <premise model="tutorial_5" category="conception" type="motor">
            <information value="turn_right" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_5" category="command" type="motor">
            <information value="turn_right"/>
            <output value="1"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="exploration">
        <scheme name="advance">
          <rule name="front_advance_action">
            <premise model="exploration" category="conception" type="state">
              <information value="advance" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_5" category="conception" type="motor">
              <information value="advance"/>
            </conclusion>
          </rule>
          <rule name="advance_action">
            <premise model="exploration" category="conception" type="state">
              <information value="advance" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_5" category="command" type="motor">
              <information value="advance" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="*1" tolerance="0"/>
            </premise>
            <premise model="tutorial_5" category="perception" type="strength" inhibitor="true">
              <information value="failed" tolerance="INF"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_5" category="conception" type="motor">
              <information value="advance"/>
            </conclusion>
          </rule>
        </scheme>
        <scheme name="turn">
          <scheme name="orientation">
            <rule name="initialize" relevance="0">
              <conclusion model="orientation" category="conception" type="orientation">
                <information value="right" delay="INF"/>
              </conclusion>
            </rule>
            <rule name="set_right">
              <premise model="orientation" category="conception" type="orientation">
                <information value="right" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="orientation" category="conception" type="orientation">
                <information value="right" delay="INF"/>
              </conclusion>
            </rule>
            <rule name="front_right">
              <premise model="orientation" category="conception" type="orientation">
                <information value="left" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="exploration" category="conception" type="event">
                <information value="line_beginning" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="orientation" category="conception" type="orientation">
                <information value="right"/>
              </conclusion>
            </rule>
            <rule name="set_left" relevance="1">
              <premise model="orientation" category="conception" type="orientation">
                <information value="left" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="orientation" category="conception" type="orientation">
                <information value="left" delay="INF"/>
              </conclusion>
            </rule>
            <rule name="front_left">
              <premise model="orientation" category="conception" type="orientation">
                <information value="right" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="exploration" category="conception" type="event">
                <information value="line_beginning" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="orientation" category="conception" type="orientation">
                <information value="left"/>
              </conclusion>
            </rule>
          </scheme>
          <scheme name="left">
            <rule name="front_turn_action_left">
              <premise model="exploration" category="conception" type="state">
                <information value="turn" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <premise model="orientation" category="conception" type="orientation">
                <information value="left" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <conclusion model="tutorial_5" category="conception" type="motor">
                <information value="turn_left"/>
              </conclusion>
            </rule>
            <rule name="turn_action_left">
              <premise model="exploration" category="conception" type="state">
                <information value="turn" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="orientation" category="conception" type="orientation">
                <information value="left" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="exploration" category="conception" type="event">
                <information value="line_ending" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="*5" tolerance="0"/>
              </premise>
              <premise model="tutorial_5" category="perception" type="strength" inhibitor="true">
                <information value="failed" tolerance="INF"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="tutorial_5" category="conception" type="motor">
                <information value="turn_left"/>
              </conclusion>
            </rule>
          </scheme>
          <scheme name="right">
            <rule name="front_turn_action_right">
              <premise model="exploration" category="conception" type="state">
                <information value="turn" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <premise model="orientation" category="conception" type="orientation">
                <information value="right" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <conclusion model="tutorial_5" category="conception" type="motor">
                <information value="turn_right"/>
              </conclusion>
            </rule>
            <rule name="turn_action_right">
              <premise model="exploration" category="conception" type="state">
                <information value="turn" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="orientation" category="conception" type="orientation">
                <information value="right" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="-1" tolerance="INF"/>
              </premise>
              <premise model="exploration" category="conception" type="event">
                <information value="line_ending" tolerance="0"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="*5" tolerance="0"/>
              </premise>
              <premise model="tutorial_5" category="perception" type="strength" inhibitor="true">
                <information value="failed" tolerance="INF"/>
                <credibility value="1" tolerance="INF"/>
                <timespan value="0" tolerance="0"/>
              </premise>
              <conclusion model="tutorial_5" category="conception" type="motor">
                <information value="turn_right"/>
              </conclusion>
            </rule>
          </scheme>
          <rule name="turn_action_advance">
            <premise model="exploration" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration" category="conception" type="event">
              <information value="line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="*2" tolerance="0"/>
            </premise>
            <conclusion model="tutorial_5" category="conception" type="motor">
              <information value="advance"/>
            </conclusion>
          </rule>
        </scheme>
        <scheme name="events">
          <rule name="line_beginning">
            <premise model="exploration" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration" category="conception" type="event">
              <information value="line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="*6" tolerance="0"/>
            </premise>
            <premise model="exploration" category="conception" type="event" inhibitor="true">
              <information value="last_line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="exploration" category="conception" type="event">
              <information value="line_beginning"/>
            </conclusion>
          </rule>
          <rule name="line_ending">
            <premise model="exploration" category="conception" type="state">
              <information value="advance" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="tutorial_5" category="perception" type="strength">
              <information value="failed" tolerance="INF"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="exploration" category="conception" type="event">
              <information value="line_ending"/>
            </conclusion>
          </rule>
          <rule name="last_line_ending">
            <premise model="exploration" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration" category="conception" type="event">
              <information value="line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="*5" tolerance="0"/>
            </premise>
            <premise model="tutorial_5" category="perception" type="strength">
              <information value="failed" tolerance="INF"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="exploration" category="conception" type="event">
              <information value="last_line_ending"/>
            </conclusion>
          </rule>
          <rule name="while_pause">
            <premise model="exploration" category="conception" type="event">
              <information value="pause" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="*1" tolerance="0"/>
            </premise>
            <premise model="exploration" category="conception" type="state" inhibitor="true">
              <information value="wait" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="exploration" category="conception" type="event">
              <information value="pause"/>
            </conclusion>
          </rule>
        </scheme>
      </scheme>
      <scheme name="reaction">
        <rule name="stimulus">
          <premise model="tutorial_5" category="perception" type="hue">
            <information value="red" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="reaction" category="conception" type="reaction" inhibitor="true">
            <information value="reaction" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <conclusion model="reaction" category="conception" type="reaction">
            <information value="reaction" delay="*5"/>
          </conclusion>
        </rule>
        <rule name="sound">
          <premise model="reaction" category="conception" type="reaction">
            <information value="reaction" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="*-5" tolerance="0"/>
          </premise>
          <conclusion model="tutorial_5" category="command" type="sound">
            <information value="red"/>
            <output value="0"/>
          </conclusion>
        </rule>
        <rule name="pause">
          <premise model="reaction" category="conception" type="reaction">
            <information value="reaction" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="*-5" tolerance="0"/>
          </premise>
          <conclusion model="exploration" category="conception" type="event">
            <information value="pause"/>
          </conclusion>
        </rule>
        <rule name="restart">
          <premise model="reaction" category="conception" type="reaction">
            <information value="reaction" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="exploration" category="conception" type="event">
            <information value="restart"/>
          </conclusion>
        </rule>
      </scheme>
    </scheme>
  </body>
  <sdk>
    <macro xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" active="true" name="hue" scheme="perceptions" xsi:type="discretization">
      <discretization xmlns="http://www.nomoseed.org/discretization" center="false">
        <rule name="hue">
          <premise model="tutorial_5" category="input" type="hue">
            <information interval="red 60 green 180 blue 300 red"/>
          </premise>
          <conclusion model="tutorial_5" category="perception" type="hue"/>
        </rule>
      </discretization>
    </macro>
  </sdk>
</program>
