<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:sdk="http://www.nomoseed.org/sdk"
                exclude-result-prefixes="sdk"> 
  <xsl:output method="xml"
              indent="yes"
              encoding="utf-8"/>
  <xsl:template match="/sdk:project[@type='model']">
    <model name="{@name}" xmlns="http://www.nomoseed.org/model">
      <xsl:call-template name="header"/>
      <definition>
        <annotation xmlns="http://www.nomoseed.org/project">
          <documentation xml:lang="{@language}">
          <xsl:value-of select="@subject"/>
          </documentation>
        </annotation>     
      </definition>
    </model>
  </xsl:template>
  <xsl:template match="/sdk:project[@type='program']">
    <program name="{@name}" xmlns="http://www.nomoseed.org/program">
      <xsl:call-template name="header"/>
      <xsl:if test="@formalism">
        <sdk>
          <formalism xmlns="http://www.nomoseed.org/sdk" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="{@formalism}">
             <xsl:element name="{@formalism}" namespace="{concat('http://www.nomoseed.org/',@formalism)}">
              <xsl:value-of select="' '"/>
            </xsl:element>
          </formalism>
        </sdk>
      </xsl:if>
    </program>
  </xsl:template>
  <xsl:template match="/sdk:project[@type='unit']">
    <unit name="{@name}" xmlns="http://www.nomoseed.org/unit" xmlns:xi="http://www.w3.org/2001/XInclude" binaryLocation="" multiplexer="no">
      <xsl:call-template name="header"/>
      <xi:include href=".eng" parse="xml"/>
      <xi:include href=".bas" parse="xml"/>
      <xi:include href=".prg" parse="xml"/>
    </unit>
  </xsl:template>
  <xsl:template match="/sdk:project[@type='inference_engine']">
    <inference_engine name="{@name}" xmlns="http://www.nomoseed.org/inference_engine">
      <xsl:call-template name="header"/>
      <frequency value="10"/>
      <forget value="0.0"/>
      <check_cover value="1.0"/>
      <bid_rate value="0.0"/>
      <reimbursement_rate value="0.0"/>
      <reward_rate value="0.0"/>
      <tax_rate value="0.0"/>
    </inference_engine>
  </xsl:template>
  <xsl:template match="/sdk:project[@type='knowledge_base']">
    <knowledge_base name="{@name}" xmlns="http://www.nomoseed.org/knowledge_base" >
      <xsl:call-template name="header"/>
      <time_span_limit value="auto"/>
      <maximum_of_maximizations value="1"/>
      <maximum_of_internal_events value="auto"/>
      <maximum_of_external_events value="1"/>
      <maximum_of_rules_by_type value="auto"/>
      <maximum_of_premises value="auto"/>
    </knowledge_base>
  </xsl:template>
   <xsl:template name="header">
    <header xmlns="http://www.nomoseed.org/project">
      <author></author>
      <copyright>
        <mention xml:lang="{@language}"></mention>
      </copyright>
      <license name="">
        <mention xml:lang="{@language}"></mention>
      </license>
      <datetime><xsl:value-of select="@datetime"/></datetime>
      <version>0.0</version>
      <annotation>
        <documentation xml:lang="{@language}">
          <xsl:value-of select="@context"/>
        </documentation>
      </annotation>
    </header>
  </xsl:template>
</xsl:stylesheet>
