#ifndef NOMOINTERPRETER_H
#define NOMOINTERPRETER_H

typedef enum {NOMO_WINNER_PARTIAL   = 0,
              NOMO_WINNER_FULL      = 1,
              NOMO_ALL_RULE_PARTIAL = 2,
              NOMO_ALL_RULE_FULL    = 3,
              NOMO_NO_LOG           = 4} nomoLogFlag;

typedef enum {NOMO_NEW_FULL_FILE    = 0,
              NOMO_NEW_PARTIAL_FILE = 1,
              NOMO_NEW_FILES        = 2,
              NOMO_ANY_NEW_FILE     = 3} nomoFileFlag;

typedef enum {NOMO_BEFORE_ASSUME    = 0,
              NOMO_AFTER_ASSUME     = 1} nomoLogPositionFlag;

typedef enum {NOMO_ANY_MODIFICATION = 0,
              NOMO_SAVE_SEED        = 1,
              NOMO_UPDATE_SEED      = 2} nomoFinalizationFlag;

typedef void (*nomoCallback) (const float intensity, const float * data);

extern void nomoInitialize (const nomoCallback * actions, const char* dirLog, const int dirLength);

extern void nomoInput (const short id, const float * data);

extern void nomoTriggers (void);

extern void nomoTriggersWithLog (const nomoLogFlag *, const nomoLogPositionFlag, const nomoFileFlag);

extern void nomoFinalize (const nomoFinalizationFlag);

#endif // NOMOINTERPRETER_H
