--  Interface for nomoInterpreter created with nomoSDK
with System;
with Nomo_Interpreter;

package Helloworld is

    use Nomo_Interpreter;

    --  Size of inputs and commands
    Command_Label_Mhelloworld_Size : constant := 1;

   --  Components of inputs and components of commands
    type Command_Label_Mhelloworld_Component is (Value);
    for Command_Label_Mhelloworld_Component use (Value => 0);
    pragma Convention (C, Command_Label_Mhelloworld_Component);
    type Command_Label_Mhelloworld_Data is array (Command_Label_Mhelloworld_Component) of Nomo_Interpreter.Real;
    pragma Convention (C, Command_Label_Mhelloworld_Data);

   --  Command functions
    procedure Command_Label_Mhelloworld (Intensity : in Real_0_To_1; Data : in System.Address);
    pragma Convention (C, Command_Label_Mhelloworld);

    Actions : constant Callbacks (1..1) := (1 => Command_Label_Mhelloworld'Access);

    --  ID of log types
    type Log_ID is (Command_Label_Mhelloworld);  --  program: pHelloWorld model: mHelloWorld
    for Log_ID use (Command_Label_Mhelloworld => 0);
    pragma Convention (C, Log_ID);

    type Log_flags is array (Log_ID) of Log_Flag;
    No_Log_Flags : constant Log_Flags := (others => No_Log);

end Helloworld;
