--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Premises_Index.Focus is

   function Get_Type_Index (This : in Premises_Focus) return Type_Index is
   begin
      pragma Assert (This.Size /= 0);
      pragma Assert (This.Last >= This.First);
      pragma Assert (This.Last - This.First + 1 = This.Size);
      return This.Index;
   end Get_Type_Index;

   function Get_First (This : in Premises_Focus) return Premise_Index is
   begin
      pragma Assert ((This.Last >= This.First) or (This.First = 1 and This.Last = 0));
      pragma Assert (This.Last - This.First + 1 = This.Size);
      return This.First;
   end Get_First;

   function Get_Last (This : in Premises_Focus) return Premise_Index is
   begin
      pragma Assert ((This.Last >= This.First) or (This.First = 1 and This.Last = 0));
      pragma Assert (This.Last - This.First + 1 = This.Size);
      return This.Last;
   end Get_Last;

   function Get_Size (This : in Premises_Focus) return Premise_Index is
   begin
      pragma Assert (This.Last - This.First + 1 = This.Size);
      return This.Size;
   end Get_Size;

end Nomo.Interpreter.Premises_Index.Focus;
