--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

with Nomo.Internal_Messages.Conclusions.Delayed.Predictive;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Numerics.Informations;

private with Nomo.Interpreter.Gen_Clusters_Base.Predictive_Loading;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Predictive_Loading);

private with Nomo.Interpreter.Prediction_Rules.Initialization;

package Nomo.Interpreter.Predictions_Clusters.Loading is

   use Numerics.Informations;

   function Get_Prediction (This        : in Predictions_Cluster;
                            Information : in Positive_Integer) return access Internal_Messages.Conclusions.Delayed.Predictive.Predictive_Conclusion;

   function Has_Space (This : in Predictions_Cluster) return Boolean;

   function Get_Last_Prediction (This : in Predictions_Cluster) return not null access Internal_Messages.Conclusions.Delayed.Predictive.Predictive_Conclusion;

   use Types_Index.Ranges;

   procedure Initialize (This            : in out Predictions_Cluster;
                         Prediction_Type : in Prediction_Type_Index);

   procedure Load (This             : in out Predictions_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);
   pragma Inline (Load);

private

   use Prediction_Rules.Initialization;

   package Local_Loading is new Predictions_Clusters_Base.Predictive_Loading (Initialize,
                                                                              Is_Equal);

end Nomo.Interpreter.Predictions_Clusters.Loading;
