--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

package Nomo.Internal_Messages.Events is

   use Numerics.Times;

   function Is_Equal (This   : in Internal_Message;
                      Target : in Internal_Message) return Boolean;

   procedure Reset_Time_Span (This : in out Internal_Message);
   pragma Inline (Reset_Time_Span);

   procedure Set (This    : out Internal_Message;
                  Content : in Internal_Message);
   pragma Inline (Set);

   procedure Update_Time_Span (This      : in out Internal_Message;
                               Time_Span : in Time_Interval);
   pragma Inline (Update_Time_Span);

end Nomo.Internal_Messages.Events;
