import com.sun.jna.Library;
import com.sun.jna.*;

import com.sun.jna.ptr.PointerByReference;

public interface NomoInterpreter extends Library {

	public static enum nomoLogFlag {
		NOMO_WINNER_PARTIAL,
		NOMO_WINNER_FULL,
		NOMO_ALL_RULE_PARTIAL,
		NOMO_ALL_RULE_FULL,
		NOMO_NO_LOG;}

	public static enum nomoFileFlag {
		NOMO_NEW_FULL_FILE,
		NOMO_NEW_PARTIAL_FILE,
		NOMO_NEW_FILES,
		NOMO_ANY_NEW_FILE;}

	public static enum nomoLogPositionFlag {
		NOMO_BEFORE_ASSUME,
		NOMO_AFTER_ASSUME;}

	public static enum nomoFinalizationFlag {
		NOMO_ANY_MODIFICATION,
		NOMO_SAVE_SEED,
		NOMO_UPDATE_SEED;}

    interface NomoCallback extends Callback {
        public void invoke(final float intensity,final Pointer data );
    }

	public class NomoCallbackStructure extends Structure{
		public NomoCallbackStructure(){super();}
		public NomoCallbackStructure(Pointer pointer){super(pointer);}
		public static class ByValue extends NomoInterpreter.NomoCallbackStructure implements Structure.ByValue {};
		public NomoCallback callback;
		public static class ByReference extends NomoInterpreter.NomoCallbackStructure implements Structure.ByReference {};
	}

	public void nomoInitialize (final NomoCallbackStructure [] actions, final String dirLog, final int dirLength);

	public void nomoInput (final short id, final Pointer data);

	public void nomoTriggers ();

	public void nomoTriggersWithLog (final Pointer logFlag, final int logPositionFlag, final int fileFlag);

	public void nomoFinalize (final int finalizationFlag);

}