#  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation, version 2 of the License.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program. If not, see <http://www.gnu.org/licenses/>

options(error=dump.frames)
library(tcltk)
library(sqldf)
library(RSVGTipsDevice)
rm(list = ls())

tableView <- function(sql){
	view = sqldf(sql)
	n = names(view)
	if (any(n=="color")){
		color = c(1:length(view$color))
		if (length(view[1])>0){
			label = unique(view$color)
			if (length(label)<2)
				color = rep('red',length(view$color))
			else {
				p = palette(rainbow(length(label),s = 0.9, v = 0.8))
				p = palette(rainbow(length(label),s = 0.9, v = 0.8))
				for (i in 1:length(view$color))
					color[i] = p[which(label == view$color[i])]
			}
		}
		write.csv(color, 'web/logging/color.csv', row.names = FALSE, quote = FALSE)
		if (length(view)>1)
			view$color = NULL;
	} else if (any(n=="hue") && any(n=="saturation") && any(n=="luminance")){
		color = c(1:length(view$hue))
		if (length(view$hue)>0){
			for (i in 1:length(view$hue))
				color[i] = hsv(view[i,"hue"]/360, view[i,"saturation"]/100, view[i,"luminance"]/100)
		}
		write.csv(color, 'web/logging/color.csv', row.names = FALSE, quote = FALSE)
		if (length(view)>3){
			view$hue = NULL;
			view$saturation = NULL;
			view$luminance = NULL;
		}
	}
	write.csv(view, 'web/logging/view.csv', row.names = FALSE, quote = FALSE)
	print('OkTableView')
}

graphicView <- function(sql, h, w){
	view = sqldf(sql)
	n = names(view)
	if (length(n)>1 && length(view[1])>0){
		color = 0
		if (any(n=="color")){
			color = c(1:length(view$color))
			label = unique(view$color)
			if (length(label)<2)
				color = rep('red',length(view$color))
			else {
				p = palette(rainbow(length(label), s = 0.9, v = 0.8))
				p = palette(rainbow(length(label), s = 0.9, v = 0.8))
				for (i in 1:length(view$color))
					color[i] = p[which(label == view$color[i])]
			}
			if (length(view)>2)
				view$color = NULL;
		}
		else if (any(n=="hue") && any(n=="saturation") && any(n=="luminance")){
			color = c(1:length(view$hue))
			for (i in 1:length(view$hue))
				color[i] = hsv(view[i,"hue"]/360, view[i,"saturation"]/100, view[i,"luminance"]/100)
			if (length(view)>4){
				view$hue = NULL;
				view$saturation = NULL;
				view$luminance = NULL;
			}
		}
		else if (length(view)>2)
			color = rainbow(length(view)-1, s = 0.9, v = 0.8)
		else
			color = 'red'
		devSVGTips('web/logging/view.svg', toolTipMode=0, width=w/72,height=h/72)
		if (any(n=="time")){
				col_idx <- grep("time", n)
			view <- view[, c(col_idx, (1:ncol(view))[-col_idx])]
			if (length(view) == 2)
				plot(view, col=color, xlab="time (ms)", lwd=2)
			else if (length(n) == length(view)){
				plot(view$time, view[,2], col=color[1], pch=1, xlim=c(min(view$time), max(view$time)), ylim=c(min(view[2:length(view)]),max(view[2:length(view)])), type="p", main="", xlab="time (ms)", ylab="", lwd=2)
				for (i in 3:length(view))
					points(view$time, view[,i], col=color[i-1])
			}
			else {
				plot(view$time, view[,2], col=color, pch=1, xlim=c(min(view$time), max(view$time)), ylim=c(min(view[2:length(view)]),max(view[2:length(view)])), type="p", main="", xlab="time (ms)", ylab="", lwd=2)
				for (i in 3:length(view))
					points(view$time, view[,i], col=color, pch= i-1)
			}
		}
		else {
			for (i in 1:length(view))
				if (is.character(view[1,i])) {
					view[,i] = factor(view[,i])
				}
			pairs(view, col=color)
		}
		dev.off()
		print('OkGraphicView')
		}
	else
		tableView(sql);
}