--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Internal_Messages;

private package Nomo.Interpreter.Internal_Events is

   use Internal_Messages;

   type Internal_Event is tagged limited private;

   use Numerics.Times;

   function After (This : in Internal_Event;
                   T    : in Positive_Time) return Boolean;
   pragma Inline (After);

   function Before (This : in Internal_Event;
                    T    : in Positive_Time) return Boolean;
   pragma Inline (Before);

   function Is_Equal (This   : in Internal_Event;
                      Target : in Internal_Event) return Boolean;

   function Get_Arrival_Time (This : in Internal_Event) return Positive_Time;
   pragma Inline (Get_Arrival_Time);

   procedure Get_Content (This    : in Internal_Event;
                          Content : out Internal_Message);

   procedure Get_Event (This         : in Internal_Event;
                        Arrival_Time : out Positive_Time;
                        Content      : out Internal_Message);

   function Not_Expired (This : in Internal_Event;
                         T    : in Positive_Time) return Boolean;
   pragma Inline (Not_Expired);

   procedure Reset_Time_Span (This : out Internal_Event);
   pragma Inline (Reset_Time_Span);

   procedure Set_Event (This         : out Internal_Event;
                        Content      : in Internal_Message;
                        Arrival_Time : in Positive_Time);

   function To_Internal_Message (This : in Internal_Event) return not null access constant Internal_Message;
   pragma Inline (To_Internal_Message);

   procedure Update_Time_Span (This         : in out Internal_Event;
                               Current_Time : in Positive_Time);

private

   type Internal_Event is new Internal_Message with record
      --  Moment o l'vnement intentionnel devient un
      --  vnement vident.
      Arrival_Time : Positive_Time := 0;
      --  Moment o l'vnement sera oubli.
      End_Time     : Positive_Time := 0;
   end record;

end Nomo.Interpreter.Internal_Events;
