--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;

with Nomo.Numerics.Accurately;

with Nomo.Interpreter.Storages;

with Nomo.Internal_Messages.Conclusions.Delayed.Predictive;

limited with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

package Nomo.Interpreter.Check_Rules.Initialization is

   use Numerics.Informations;
   use Numerics.Accurately;
   use Storages;

   function Get_Prediction_Information (This : in Check_Rule) return Positive_Integer;

   procedure Initialize (This                       : out Check_Rule;
                         Rule_Storage               : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately;
                         Prediction_Type            : in Prediction_Type_Index);

   use Internal_Messages.Conclusions.Delayed.Predictive;

   package Initial is
      procedure Set_Linked_Prediction (This              : out Check_Rule;
                                       Linked_Prediction : access Predictive_Conclusion);
   end Initial;

   package Inline is
      procedure Set_Linked_Prediction (This              : out Check_Rule;
                                       Linked_Prediction : not null access Predictive_Conclusion);
   end Inline;

end Nomo.Interpreter.Check_Rules.Initialization;
