#!/bin/bash
cd $(dirname $0)

rm -f nomoTools
rm -f libnomotools.so
cd ../nomotools
if [ ! -f nomoTools ]
then
    bash build.sh
fi
cp nomoTools ../nomosdk
cp nomoTime ../nomosdk
cp libnomotools.so ../nomosdk
cp categories_colors.xml ../nomosdk
cd grammars
cp *.xsd ../../nomosdk/grammars
cd ../transformations
cp *.xsl ../../nomosdk/transformations
cd ..
mkdir ../nomosdk/helloworld
cp -a helloworld/ ../nomosdk/

rm -f ../nomosdk/libnomointerpreter.so
cd ../nomointerpreter
if [ ! -f libnomointerpreter.so ]
then
    bash build.sh
fi
cp libnomointerpreter.so ../nomosdk
cp -a helloworld/ ../nomosdk/

export PATH=/usr/local/Trolltech/Qt-4.8.4/bin:$PATH
export C_INCLUDE_PATH=/usr/include/i386-linux-gnu:$C_INCLUDE_PATH
export CPLUS_INCLUDE_PATH=/usr/include/i386-linux-gnu:$CPLUS_INCLUDE_PATH

cd ../../src/formalisms/automaton
echo Build dynamic library automaton
qmake
make
mv libautomaton.so.1.0.0 ../../../build/nomosdk/formalisms/automaton/libautomaton.so
rm -f Makefile
rm -f *.o
rm -f libautomaton.*

cd ../boolean_logic
echo Build dynamic library boolean_logic
qmake
make
mv libboolean_logic.so.1.0.0 ../../../build/nomosdk/formalisms/boolean_logic/libboolean_logic.so
rm -f Makefile
rm -f *.o
rm -f libboolean_logic.*

cd ../../macros/formulation
echo Build dynamic library formulation
qmake
make
mv libformulation.so.1.0.0 ../../../build/nomosdk/macros/formulation/libformulation.so
rm -f Makefile
rm -f *.o
rm -f libformulation.*

cd ../discretization
echo Build dynamic library discretization
qmake
make
mv libdiscretization.so.1.0.0 ../../../build/nomosdk/macros/discretization/libdiscretization.so
rm -f Makefile
rm -f *.o
rm -f libdiscretization.*

cd ../../benchmarks/worldsquare
echo Build dynamic library worldsquare
export LIBRARY_PATH=../../../build/nomosdk:$LIBRARY_PATH 
export LD_LIBRARY_PATH=../../../build/nomosdk:$LD_LIBRARY_PATH 
qmake
make
mv libworldsquare.so.1.0.0 ../../../build/nomosdk/libworldsquare.so
rm -f Makefile
rm -f *.o
rm -f libworldsquare.*
export PATH=/usr/gnat/bin:$PATH
export LIBRARY_PATH=/usr/lib/i386-linux-gnu:$LIBRARY_PATH 
echo Build executable worldsquare
gnatmake -Pworldsquare.gpr 
rm -f b~worldsquare.ads
rm -f b~worldsquare.adb
rm -f *.o
rm -f *.ali
mv worldsquare ../../../build/nomosdk
mv ../../../build/nomosdk/libworldsquare.so ../../../build/nomosdk/libworldsquare.so.1

cd ../pointsscatter
echo Build dynamic library pointsscatter
qmake
make
mv libpointsscatter.so.1.0.0 ../../../build/nomosdk/libpointsscatter.so
rm -f Makefile
rm -f *.o
rm -f libpointsscatter.*
echo Build executable pointsscatter
gnatmake -Ppointsscatter.gpr 
rm -f b~pointsscatter.ads
rm -f b~pointsscatter.adb
rm -f *.o
rm -f *.ali
mv pointsscatter ../../../build/nomosdk
mv ../../../build/nomosdk/libpointsscatter.so ../../../build/nomosdk/libpointsscatter.so.1

cd ../../nomosdk
find  -name '*.xsl' -exec sed -e '/\r$/!s/$/\r/' {} \;
echo Build executable nomoSDK
qmake
make
rm -f Makefile
rm -f *.o
mv nomoSDK_exe ../../build/nomosdk
mkdir ../../build/nomosdk/translations
cp translations/*.qm ../../build/nomosdk/translations

cd ../../build/nomosdk

rm -f nomoSDK

cat>> nomoSDK <<EOF
export LIBRARY_PATH=$(dirname $0)
export LD_LIBRARY_PATH=$(dirname $0):$(dirname $0)/macros/formulation:$(dirname $0)/macros/descretization:$(dirname $0)/formalisms/automaton:$(dirname $0)/formalisms/boolean_logic
./nomoSDK_exe
EOF

exit 0
