--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

package body Nomo.Interpreter.External_Messages.Events is

   procedure Set_Content (This    : out External_Message;
                          Content : in System.Address;
                          Size    : in Component_Index) is
      use Numerics.Reals;
      Data : array (1 .. Size) of Real;
      for Data'Address use Content;
   begin
      for I in Data'Range loop
         This (I) := Data (I);
      end loop;
   end Set_Content;

end Nomo.Interpreter.External_Messages.Events;
