--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Internal_Messages.Premises.Initialization is

   function Get_Tolerance (This : in Internal_Premise) return Tolerance_Flag is
   begin
      return This.Tolerance;
   end Get_Tolerance;

   function Get_Information (This : in Internal_Premise) return Positive_Integer is
   begin
      return This.Information;
   end Get_Information;

   procedure Set (This   : out Internal_Premise;
                  Target : in Internal_Premise) is
   begin
      This.Information := Target.Information;
      This.Time_Span := Target.Time_Span;
      This.Credibility := Target.Credibility;
      This.Actuator_Time_Span := Target.Actuator_Time_Span;
      This.Time_Span_Tolerance := Target.Time_Span_Tolerance;
      This.Time_Span_Trend := Target.Time_Span_Trend;
      This.Actuator_Credibility := Target.Actuator_Credibility;
      This.Credibility_Tolerance := Target.Credibility_Tolerance;
      This.Credibility_Trend := Target.Credibility_Trend;
      This.Tolerance := Target.Tolerance;
      This.Specificity_Log := Target.Specificity_Log;
   end Set;

end Nomo.Internal_Messages.Premises.Initialization;
