--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Ada.Streams.Stream_IO;

private with Nomo.File_Properties;

private package Nomo.Reader is

private

   use File_Properties.Seed;

   function Get_Binary_Stream (Data : in Data_Type) return not null Ada.Streams.Stream_IO.Stream_Access;
   pragma Precondition(Data /= Rules);

   function Get_Rule_Stream (I : in Positive) return not null Ada.Streams.Stream_IO.Stream_Access;

   Corrupt_File   : exception;
   Missing_File   : exception;
   Too_Many_Files : exception;

   Path_Size_Max : constant Positive := 500;

   Binary_File      : Ada.Streams.Stream_IO.File_Type;
   Binary_Path      : String (1 .. Path_Size_Max);
   Binary_Path_Size : Natural;

end Nomo.Reader;
