--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Interpreter.Types_Index.Ranges;

limited with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

limited with Nomo.Interpreter.Premises_Index.Arrays;

limited with Nomo.Interpreter.Premises_Index.Focus;

package Nomo.Interpreter.Event_Memory.Internal.Discernment is

   use Numerics.Reals;
   use Types_Index.Ranges;

   procedure Discern_Exciting_Evidences (I            : in Internal_Type_Index;
                                         Matchmaker   : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                                         Propositions : not null access Premises_Index.Arrays.Internal_Premises;
                                         Designation  : in Premises_Index.Focus.Premises_Focus;
                                         Distance     : out Positive_Real);
   pragma Inline(Discern_Exciting_Evidences);

   procedure Discern_Exciting_Intentions (I            : in Internal_Type_Index;
                                          Matchmaker   : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                                          Propositions : not null access Premises_Index.Arrays.Internal_Premises;
                                          Designation  : in Premises_Index.Focus.Premises_Focus;
                                          Distance     : out Positive_Real);
   pragma Inline(Discern_Exciting_Intentions);

   procedure Discern_Inhibiting_Evidences (I            : in Internal_Type_Index;
                                           Matchmaker   : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                                           Propositions : not null access constant Premises_Index.Arrays.Internal_Premises;
                                           Designation  : in Premises_Index.Focus.Premises_Focus;
                                           Score        : out Positive_Real);
   pragma Inline(Discern_Inhibiting_Evidences);

   procedure Discern_Inhibiting_Intentions (I            : in Internal_Type_Index;
                                            Matchmaker   : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                                            Propositions : not null access constant Premises_Index.Arrays.Internal_Premises;
                                            Designation  : in Premises_Index.Focus.Premises_Focus;
                                            Score        : out Positive_Real);
   pragma Inline(Discern_Inhibiting_Intentions);

end Nomo.Interpreter.Event_Memory.Internal.Discernment;
