--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Rules_Directories.Logging;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Logging);

with Nomo.Interpreter.Check_Rules.Logging;

with Nomo.Interpreter.Logger;

package body Nomo.Interpreter.Checks_Clusters.Logging is

   use Check_Rules.Logging;

   package Local_Logging is new Local_Rules_Directories.Logging (Log_Full,
                                                                 Log_Partial);

   procedure Log (This       : in Checks_Cluster;
                  Buffer_Ptr : not null access Storages.Full_Rule_Storage;
                  Flag       : in Log_Flag) is
      use Local_Logging;
   begin
      case Flag is
         when Winner_Partial =>
            if This.Selected_Rule /= null then
               Log_Partial (This.Selected_Rule.all, Buffer_Ptr);
               Logger.Log_Partial (Buffer_Ptr);
            end if;
         when Winner_Full =>
            if This.Selected_Rule /= null then
               Log_Full (This.Selected_Rule.all, Buffer_Ptr);
               Logger.Log_Full (Buffer_Ptr);
            end if;
         when All_Rule_Partial =>
            Log_Partial (Rules_Directory (This.Directory), Buffer_Ptr);
         when All_Rule_Full =>
            Log_Full (Rules_Directory (This.Directory), Buffer_Ptr);
         when others =>
            null;
      end case;
   end Log;

end Nomo.Interpreter.Checks_Clusters.Logging;
