﻿//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef NOMOINTERPRETER_H
#define NOMOINTERPRETER_H

typedef enum {NOMO_WINNER_PARTIAL   = 0,
              NOMO_WINNER_FULL      = 1,
              NOMO_ALL_RULE_PARTIAL = 2,
              NOMO_ALL_RULE_FULL    = 3,
              NOMO_NO_LOG           = 4} nomoLogFlag;

typedef enum {NOMO_NEW_FULL_FILE    = 0,
              NOMO_NEW_PARTIAL_FILE = 1,
              NOMO_NEW_FILES        = 2,
              NOMO_ANY_NEW_FILE     = 3} nomoFileFlag;

typedef enum {NOMO_BEFORE_ASSUME    = 0,
              NOMO_AFTER_ASSUME     = 1} nomoLogPositionFlag;

typedef enum {NOMO_ANY_MODIFICATION = 0,
              NOMO_SAVE_SEED        = 1,
              NOMO_UPDATE_SEED      = 2} nomoFinalizationFlag;

typedef void (*nomoCallback) (const float intensity, const float * data);

#ifdef WIN32
#define IMPORT __declspec(dllimport)
#else
#define IMPORT
#endif

extern "C" IMPORT void nomoInitialize (const nomoCallback* actions, const char* dirLog, const int dirLength);

extern "C" IMPORT void nomoInput (const short id, const float * data);

extern "C" IMPORT void nomoTriggers (void);

extern "C" IMPORT void nomoTriggersWithLog (const nomoLogFlag *, const nomoLogPositionFlag, const nomoFileFlag);

extern "C" IMPORT void nomoFinalize (const nomoFinalizationFlag);

#endif // NOMOINTERPRETER_H
