--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Gen_Types_Index;

with Nomo.Numerics.Times;

with Nomo.Logging_Flags;

with Nomo.Type_Categories;
use Nomo.Type_Categories;

private with Nomo.Gen_Time_Log_Header.Writing;
pragma Elaborate_All (Nomo.Gen_Time_Log_Header.Writing);

private generic
   Partial_Storage_Size : Positive;
   type Full_Storage is limited private;
   Maximum_Of_Premises   : Natural;
   Maximum_Of_Components : Natural;
   with package Types_Index is new Nomo.Gen_Types_Index (<>);
   use Types_Index;
   Number_Of_Input_Types : Type_Index;
   with function Get_Category (I : in Type_Index) return Type_Category;
package Nomo.Gen_Logger is

   procedure Initialize (Log_Directory : in String);

   procedure Finalize;

   procedure Log_Partial (Buffer_Ptr : not null access Full_Storage);

   procedure Log_Full (Buffer_Ptr : not null access Full_Storage);

   use Numerics.Times;
   use Logging_Flags;

   procedure Set_Time (T       : in Positive_Time;
                       Context : in File_Flag);

   function Get_Directory return String;

private

   package Time_Log_Header is new Gen_Time_Log_Header (Types_Index,
                                                       Number_Of_Input_Types);

   package Time_Log_Header_Writing is new Time_Log_Header.Writing (Get_Category);

end Nomo.Gen_Logger;
