--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Times;

with Nomo.Internal_Messages;

private with Nomo.Interpreter.Rules_Base.Spontaneous;

private with Nomo.Internal_Messages.Conclusions.Instantaneous;

private with Nomo.Interpreter.Reward_Conditions;

private package Nomo.Interpreter.Reward_Rules is

   use Numerics.Accurately;
   use Numerics.Reals;
   use Numerics.Times;

   type Reward_Rule is tagged limited private;

   procedure Adjust (This            : in out Reward_Rule;
                     Specificity_Log : in out Real_Accurately);

   procedure Evaluate (This  : in out Reward_Rule;
                       Score : out Positive_Real);

   procedure Evaluate (This  : in out Reward_Rule;
                       Shift : in Real_Accurately;
                       Score : out Positive_Real);

   function Get_Conclusion (This : in Reward_Rule) return not null access constant Internal_Messages.Internal_Message;

   function Get_First_Landmark (This : in Reward_Rule) return Positive_Time_Interval;
   pragma Inline (Get_First_Landmark);

   function Get_Second_Landmark (This : in Reward_Rule) return Positive_Time_Interval;
   pragma Inline (Get_Second_Landmark);

   function Get_Reward_Quantity (This : in Reward_Rule) return Real_Accurately_0_To_1;
   pragma Inline (Get_Reward_Quantity);

   function Is_Forget (This : in Reward_Rule) return Boolean;
   pragma Inline (Is_Forget);

   function Is_Updatable (This : in Reward_Rule) return Boolean;
   pragma Inline (Is_Updatable);

   procedure Update_Relevance (This : in out Reward_Rule);

   procedure Update_Relevance (This       : in out Reward_Rule;
                               Scores_Sum : in Strictly_Positive_Real);

private

   use Rules_Base.Spontaneous;
   use Internal_Messages.Conclusions.Instantaneous;
   use Reward_Conditions;

   type Reward_Rule is new Spontaneous_Rule with record
      Conclusion : aliased Instantaneous_Conclusion;
      Condition  : Reward_Condition;
   end record;

end Nomo.Interpreter.Reward_Rules;
