<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Première étape de l'encodage :
	- Eliminer les modèles redondant comme les instances par importation ou les instances héritées.
	- Eliminer les commentaires s'ils se présentent.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:program="http://www.nomoseed.org/program" xmlns:model="http://www.nomoseed.org/model" xmlns:unit="http://www.nomoseed.org/unit" xmlns:code="http://www.nomoseed.org/code" xmlns:project="http://www.nomoseed.org/project">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:param name="binaryLocation" select="'ici'"/>
	<xsl:template match="unit:unit">
		<xsl:element name="code:code">
			<xsl:attribute name="unit">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:program">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs | program:models | program:body| program:sdk">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:inherite">
		<xsl:variable name="inherite" select="@model"/>
		<xsl:variable name="list" select="./ancestor::program:program/program:body/program:models/program:new[@model=$inherite] | ./ancestor::program:program/program:body/program:models/program:inherite[@model=$inherite]"/>
		<xsl:if test="count($list)=1">
			<xsl:copy>
				<xsl:attribute name="instance">
					<xsl:value-of select="@instance"/>
				</xsl:attribute>
				<xsl:attribute name="prototype">
					<xsl:value-of select="@prototype"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="@model"/>
				</xsl:attribute>
				<xsl:apply-templates/>
			</xsl:copy>
		</xsl:if>
	</xsl:template>
	<xsl:template match="program:models/program:new">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs/program:new | program:programs/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:import"/>
	<xsl:template match="program:inspection"/>
	<xsl:template match="project:*"/>
	<xsl:template match="*">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
