--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

generic
   with procedure Initialize (This  : in out Cluster;
                              Index : in Index_Type);
   with function Has_Space (I : in Cluster) return boolean;
   with procedure Load (This             : in out Cluster;
                        Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);
package Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading is


   function Has_Space (I : in Index_Type) return boolean;

   procedure Load (I                : in Index_Type;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);
   pragma Inline (Load);

   generic
      type Cluster_Associated is limited private;
      type Index_Type_Associated is (<>);

      with procedure Initialize_Links (This   : in out Cluster;
                                       Target : in Cluster_Associated);
      with procedure Update_Last_Link (This   : in out Cluster;
                                       Target : in out Cluster_Associated);
      with function Get_Cluster (I : in Index_Type_Associated) return not null access Cluster_Associated;
      with function Get_Type_Associated (I : in Index_Type) return Index_Type_Associated;
      with function Has_Type_Associated (I : in Index_Type) return Boolean;
   package Linking is

      procedure Initialize;

      procedure Update_Last (I : in Index_Type);

   end Linking;

   generic
   function Get_Cluster (I : in Index_Type) return not null access Cluster;

end Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading;
