<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Quatrième étape de l'encodage :
	- Supression de tout élément et attribut inutile à la compilation ou à la génération de l'interface.
	- Ajustement des identifiants
	- Renommer les types pour la génération de l'interface
	- Récapituler l'arborescence des programmes et le modèle incluant le type, ceci servira de commentaire aux types dans l'interface.
	- Caculer certaines constantes globales.
  - Ordornner les prémisses par catégorie et par propriété.
  - Inverser l'ordre des règles.
  - Ajouter les attributs 'program' et 'scheme' aux éléments 'rule'
-->

<xsl:stylesheet version="1.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:program="http://www.nomoseed.org/program" xmlns:plant="http://www.nomoseed.org/plant" xmlns:model="http://www.nomoseed.org/model" xmlns:inference_engine="http://www.nomoseed.org/inference_engine" xmlns:knowledge_base="http://www.nomoseed.org/knowledge_base" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:code="http://www.nomoseed.org/code" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:variable name="multiplexer" select="/code:code/@multiplexer"/>
	<xsl:key name="declarationKey" match="model:declaration | plant:declaration" use="@category"/>
	<xsl:key name="modelKey" match="program:new | program:inherite" use="@model"/>
	<xsl:variable name="last_input" select="count(key('declarationKey','input'))"/>
	<xsl:variable name="last_command" select="count(key('declarationKey','command')) + $last_input"/>
	<xsl:variable name="last_perception" select="count(key('declarationKey','perception')) + $last_command"/>
	<xsl:variable name="last_conception" select="count(key('declarationKey','conception')) + $last_perception"/>
	<xsl:variable name="last_prediction" select="count(key('declarationKey','prediction')) + $last_conception"/>
	<xsl:variable name="last_landmark" select="count(key('declarationKey','landmark')) + $last_prediction"/>
	<xsl:variable name="last_operator" select="count(key('declarationKey','operator')) + $last_landmark"/>
	<xsl:variable name="last_scope" select="count(key('declarationKey','scope')) + $last_operator"/>
	<xsl:variable name="last_transition" select="count(key('declarationKey','transition')) + $last_scope"/>
	<xsl:variable name="last_reward" select="count(key('declarationKey','reward')) + $last_transition"/>
	<xsl:variable name="last_anomaly" select="count(key('declarationKey','anomaly')) + $last_reward"/>
	<xsl:variable name="maximum_of_premises">
		<xsl:for-each select="//program:rule">
			<xsl:sort select="count(.//program:premise)" order="descending"/>
			<xsl:if test="position()=1">
				<xsl:value-of select="count(.//program:premise)"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
  <xsl:variable name="timestep">
    <xsl:value-of select="floor(1000 div (//inference_engine:frequency/@value))"/>
  </xsl:variable>
	<xsl:variable name="maximum_of_timespan">
      <xsl:for-each select="//program:premise">
        <xsl:sort select="./program:timespan[not(contains(@value, 'M'))]/@value" order="descending"/>
        <xsl:if test="position()=1">
          <xsl:choose>
            <xsl:when test="./program:timespan/@value &gt; 0">
              <xsl:value-of select="./program:timespan/@value "/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="0"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
	</xsl:variable>
	<xsl:variable name="maximum_of_rules_by_type">
    <xsl:call-template name="maxRulesByType">
      <xsl:with-param name="n" select="1"/>
      <xsl:with-param name="declaration" select="//model:declaration | //plant:declaration"/>
      <xsl:with-param name="max" select="1"/>
    </xsl:call-template>
	</xsl:variable>
	<xsl:variable name="maximum_of_internal_events">
		<xsl:for-each select="//program:rule[.//program:premise]">
			<xsl:sort select="count(.//program:premise) div count(./program:excitatory/* | ./program:inhibitory/*[parent::*/parent::*/program:excitatory[local-name(.)]])" order="descending"/>
			<xsl:if test="position()=1">
				<xsl:value-of select="ceiling(count(.//program:premise) div count(./program:excitatory/* | ./program:inhibitory/*[parent::*/parent::*/program:excitatory[local-name(.)]]))"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:template match="code:code">
		<xsl:copy>
			<xsl:attribute name="unit">
				<xsl:value-of select="@unit"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:variable name="number_of_operator_other" select="count(//plant:item[ancestor::plant:operator_type and ancestor::plant:other])"/>
			<xsl:variable name="number_of_operator_input" select="count(//plant:item[ancestor::plant:operator_type and ancestor::plant:input])"/>
			<xsl:variable name="number_of_scope_other" select="count(//plant:item[ancestor::plant:scope_type and ancestor::plant:other])"/>
			<xsl:variable name="number_of_scope_input" select="count(//plant:item[ancestor::plant:scope_type and ancestor::plant:input])"/>
			<xsl:variable name="number_of_types" select="count(//model:declaration | //plant:declaration)"/>
			<xsl:variable name="number_of_rules" select="count(//program:rule[@id])"/>
			<xsl:variable name="maximum_of_components">
				<xsl:for-each select="key('declarationKey','command') | key('declarationKey','input')">
					<xsl:sort select="@data_size" order="descending"/>
					<xsl:if test="position()=1">
						<xsl:value-of select="@data_size"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable><!--  !!rajouter les xmlns correspondant!!
      <xsl:variable name="allRelevanceFixe" select="count(//program:rule[@relevance != 1.0]) = 0" />
      <xsl:variable name="predictionPresent" select="count(//program:rules/program:prediction) != 0" />
      <xsl:variable name="rewardPresent" select="count(//program:rules/program:reward) != 0" />
      <xsl:if test="$premiseMax &lt; //engine:maximum_of_premises/@value">
        <xsl:message terminate="yes">Error : maximum_of_premises failed</xsl:message>
      </xsl:if>
      <xsl:if test="$ruleMax &lt; //engine:maximum_of_rules_by_type/@value">
        <xsl:message terminate="yes">Error : maximum_of_rules_by_type failed </xsl:message>
      </xsl:if>
      <xsl:if test="//dynamic:dynamic and itemOperator = 0 and allRelevanceFixe">
        <xsl:message terminate="yes">Warning : obsolete Dynamic</xsl:message>
      </xsl:if>
  <xsl:template match="*">
    <xsl:copy-of select="." />
  </xsl:template>

-->
			<xsl:element name="code:proportions">
				<xsl:attribute name="number_of_operator_other">
					<xsl:value-of select="$number_of_operator_other"/>
				</xsl:attribute>
				<xsl:attribute name="number_of_operator_input">
					<xsl:value-of select="$number_of_operator_input"/>
				</xsl:attribute>
				<xsl:attribute name="number_of_scope_other">
					<xsl:value-of select="$number_of_scope_other"/>
				</xsl:attribute>
				<xsl:attribute name="number_of_scope_input">
					<xsl:value-of select="$number_of_scope_input"/>
				</xsl:attribute>
				<xsl:attribute name="number_of_types">
					<xsl:value-of select="$number_of_types"/>
				</xsl:attribute>
				<xsl:attribute name="number_of_rules">
					<xsl:value-of select="$number_of_rules"/>
				</xsl:attribute>
				<xsl:attribute name="maximum_of_components">
					<xsl:choose>
						<xsl:when test="string-length($maximum_of_components) != 0">
							<xsl:value-of select="$maximum_of_components"/>
						</xsl:when>
						<xsl:otherwise>
              <xsl:message terminate="no">
                <xsl:value-of select="'Internal Error'"/>
              </xsl:message>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:element>
			<xsl:apply-templates select="//inference_engine:inference_engine"/>
			<xsl:apply-templates select="//knowledge_base:knowledge_base"/>
			<xsl:element name="code:types">
				<xsl:apply-templates select="key('declarationKey','input')"/>
				<xsl:apply-templates select="key('declarationKey','command')"/>
				<xsl:apply-templates select="key('declarationKey','perception')"/>
				<xsl:apply-templates select="key('declarationKey','conception')"/>
				<xsl:apply-templates select="key('declarationKey','prediction')"/>
				<xsl:apply-templates select="key('declarationKey','landmark')"/>
				<xsl:apply-templates select="key('declarationKey','operator')"/>
				<xsl:apply-templates select="key('declarationKey','scope')"/>
				<xsl:apply-templates select="key('declarationKey','transition')"/>
				<xsl:apply-templates select="key('declarationKey','reward')"/>
				<xsl:apply-templates select="key('declarationKey','anomaly')"/>
				<xsl:apply-templates select="key('declarationKey','check')"/>
				<xsl:for-each select="//plant:input/plant:operator_type/plant:items/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:operator_input">
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="//plant:input/plant:operator_type/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:operator_input">
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
            <xsl:attribute name="information_tolerance">
              <xsl:value-of select="./plant:premise/@information_tolerance"/>
            </xsl:attribute>
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="//plant:other/plant:operator_type/plant:items/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:operator_other">
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="//plant:other/plant:operator_type/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:operator_other">          
            <xsl:variable name="target" select="plant:*/plant:target"/>
            <xsl:variable name="information" select="plant:*/plant:*/plant:information"/>
            <xsl:variable name="timespan" select="plant:premise/plant:timespan| plant:premise/*/plant:timespan"/>
            <xsl:variable name="delay" select="plant:conclusion/plant:delay | plant:conclusion/*/plant:delay"/>
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
            <xsl:if test="plant:conclusion">
              <xsl:attribute name="relevance">
                <xsl:value-of select="plant:conclusion/@relevance"/>
              </xsl:attribute>
              <xsl:attribute name="fitting_nbr">
                <xsl:value-of select="plant:conclusion/@fitting_nbr"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="$information">
              <xsl:attribute name="information_value">
                <xsl:value-of select="$information/@itemId"/>
              </xsl:attribute>
              <xsl:attribute name="type">
                <xsl:call-template name="type_index">
                  <xsl:with-param name="category" select="local-name($information/parent::*)"/>
                  <xsl:with-param name="id" select="$information/@typeId"/>
                </xsl:call-template>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="$timespan">
              <xsl:attribute name="timespan_value">
                <xsl:value-of select="$timespan/@value"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="$delay">
              <xsl:attribute name="timespan_value">
                <xsl:value-of select="concat( '-', $delay/@value)"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="plant:premise">
              <xsl:attribute name="credibility_tolerance">
                <xsl:value-of select="plant:premise/@credibility_tolerance"/>
              </xsl:attribute>
              <xsl:attribute name="timespan_tolerance">
                <xsl:value-of select="plant:premise/@timespan_tolerance"/>
              </xsl:attribute>
              <xsl:attribute name="information_tolerance">
                <xsl:value-of select="plant:premise/@information_tolerance"/>
              </xsl:attribute>
              <xsl:if test="plant:premise/plant:credibility">
                <xsl:attribute name="credibility_value">
                  <xsl:value-of select="plant:premise/plant:credibility/@value"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:if>
            <xsl:if test="$target">
              <xsl:attribute name="type">
                <xsl:call-template name="type_index">
                  <xsl:with-param name="category" select="$target/@category"/>
                  <xsl:with-param name="id" select="$target/@typeId"/>
                </xsl:call-template>
              </xsl:attribute>
            </xsl:if>
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="//plant:input/plant:scope_type/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:scope_input">
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
						<xsl:attribute name="target">
              <xsl:for-each select="./plant:target">
                <xsl:sort select="@typeId" order="ascending"/>
                <xsl:call-template name="type_index">
                  <xsl:with-param name="category" select="@category"/>
                  <xsl:with-param name="id" select="@typeId"/>
                </xsl:call-template>
                <xsl:if test="position() != last()">
                  <xsl:value-of select="' '"/>
                </xsl:if>
              </xsl:for-each>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="//plant:other/plant:scope_type/plant:item">
					<xsl:sort select="@id" order="ascending" data-type="number"/>
					<xsl:element name="code:scope_other">
						<xsl:attribute name="id">
							<xsl:value-of select="@id"/>
						</xsl:attribute>
						<xsl:attribute name="name">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
						<xsl:attribute name="target">
              <xsl:for-each select="./plant:target">
                <xsl:sort select="@typeId" order="ascending"/>
                <xsl:call-template name="type_index">
                  <xsl:with-param name="category" select="@category"/>
                  <xsl:with-param name="id" select="@typeId"/>
                </xsl:call-template>
                <xsl:if test="position() != last()">
                  <xsl:value-of select="' '"/>
                </xsl:if>
              </xsl:for-each>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
			<xsl:element name="code:rules">
				<xsl:apply-templates select="//program:rules/program:*/program:rule">
          <xsl:sort select="@id" order="descending" data-type="number"/>
        </xsl:apply-templates>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:declaration | plant:declaration">
		<xsl:for-each select=".">
			<xsl:sort select="@id" order="ascending"/>
			<xsl:element name="code:type">
				<xsl:attribute name="category">
					<xsl:value-of select="@category"/>
				</xsl:attribute>
				<xsl:attribute name="hue">
					<xsl:value-of select="@hue"/>
				</xsl:attribute>
				<xsl:attribute name="saturation">
					<xsl:value-of select="@saturation"/>
				</xsl:attribute>
				<xsl:attribute name="luminance">
					<xsl:value-of select="@luminance"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="@model"/>
				</xsl:attribute>
				<xsl:attribute name="name">
					<xsl:value-of select="@type"/>
				</xsl:attribute>
				<xsl:attribute name="model">
				  <xsl:variable name="test" select="ancestor::model:model/@model"/>
					<xsl:value-of select="$test"/>
          <xsl:if test="not($test)">
            <xsl:value-of select="'plant'"/>
          </xsl:if>
				</xsl:attribute>
        <xsl:attribute name="id">
          <xsl:call-template name="type_index">
            <xsl:with-param name="category" select="@category"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:attribute>
				<xsl:variable name="model" select="key('modelKey',@model)"/>
				<xsl:attribute name="external_name">
					<xsl:value-of select="concat (@category, '_')"/>
					<xsl:value-of select="@type"/>
					<xsl:value-of select="concat ('_', $model/@prototype)"/>
					<xsl:if test="//program:new[@prototype = $model/@prototype and @number != 1] | //program:inherite[@prototype = $model/@prototype and @number != 1]">
						<xsl:value-of select="concat ('-', $model/@number)"/>
					</xsl:if>
				</xsl:attribute>
				<xsl:attribute name="program">
          <xsl:variable name="test" select="ancestor::model:model/@program"/>
          <xsl:value-of select="$test"/>
          <xsl:if test="not($test)">
            <xsl:value-of select="ancestor::program:program/@name"/>
          </xsl:if>
          <xsl:value-of select="ancestor::model:model/@program"/>
				</xsl:attribute>
				<xsl:attribute name="external_comment">
					<xsl:value-of select="'program: '"/>
					<xsl:for-each select="ancestor::program:program">
            <xsl:if test="not(position()=1)"><xsl:value-of select="'/'"/></xsl:if>
						<xsl:value-of select="@name"/>
						<xsl:if test="../@number">
							<xsl:value-of select="concat ('-', ../@number)"/>
							<xsl:value-of select="concat (' (', ../@instance, ') ')"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="concat (' model: ', $model/@instance)"/>
				</xsl:attribute>
				<xsl:if test="@rewarded_by">
					<xsl:attribute name="rewarded_by">
						<xsl:value-of select="@rewarded_by + $last_transition"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="@predicted_by">
					<xsl:attribute name="predicted_by">
						<xsl:value-of select="@predicted_by+ $last_conception"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="@twined_with">
					<xsl:attribute name="twined_with">
						<xsl:value-of select="@twined_with + $last_perception"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="@check_associated">
					<xsl:attribute name="check_associated">
						<xsl:value-of select="@check_associated + $last_anomaly"/>
					</xsl:attribute>
					<xsl:attribute name="landmark_associated">
						<xsl:value-of select="@landmark_associated + $last_prediction"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="@perception_associated">
					<xsl:attribute name="perception_associated">
						<xsl:value-of select="@perception_associated + $last_command"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="@input_associated">
					<xsl:attribute name="input_associated">
						<xsl:value-of select="@input_associated"/>
					</xsl:attribute>
					<xsl:if test="@command_associated">
						<xsl:attribute name="command_associated">
							<xsl:value-of select="@command_associated + $last_input"/>
						</xsl:attribute>
					</xsl:if>
				</xsl:if>
				<xsl:if test="@data_size">
					<xsl:attribute name="data_size">
						<xsl:value-of select="@data_size"/>
					</xsl:attribute>
					<xsl:attribute name="components">
						<xsl:value-of select="@components"/>
					</xsl:attribute>
				</xsl:if>
         <xsl:choose>
         <xsl:when test="@category='input'">
          <xsl:apply-templates select="../../model:inputs/model:index"/>
         </xsl:when>
         <xsl:when test="@category='command'">
          <xsl:apply-templates select="../model:outputs/model:index"/>
          <xsl:apply-templates select="../model:items/model:item"/>
         </xsl:when>
					<xsl:otherwise>
          <xsl:apply-templates select="../model:items/model:item | ../parent::model:declarations/model:items/model:item | ../plant:items/plant:item | ../parent::plant:declarations/plant:items/plant:item"/>
					</xsl:otherwise>
         </xsl:choose>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="model:index">
    <xsl:element name="code:component">
				<xsl:attribute name="index">
					<xsl:value-of select="@pos"/>
				</xsl:attribute>
				<xsl:attribute name="name">
					<xsl:value-of select="@name"/>
				</xsl:attribute>
    </xsl:element>
	</xsl:template>
	<xsl:template match="model:item | plant:item">
    <xsl:element name="code:item">
				<xsl:attribute name="name">
					<xsl:value-of select="@name"/>
				</xsl:attribute>
    </xsl:element>
	</xsl:template>
	<xsl:template match="program:rule">
		<xsl:for-each select=".">
			<xsl:sort select="@id" order="ascending"/>
			<xsl:element name="code:rule">
				<xsl:attribute name="fitting_nbr">
					<xsl:value-of select="@fitting_nbr"/>
				</xsl:attribute>
				<xsl:attribute name="relevance">
					<xsl:value-of select="@relevance"/>
				</xsl:attribute>
				<xsl:attribute name="id">
					<xsl:value-of select="@id"/>
				</xsl:attribute>
				<xsl:attribute name="name">
					<xsl:value-of select="@name"/>
				</xsl:attribute>
				<xsl:attribute name="scheme">
					<xsl:for-each select="ancestor::program:scheme[@name]">
            <xsl:value-of select="@name"/>
            <xsl:if test="position() != last()">
              <xsl:value-of select="' '"/>
            </xsl:if>
					</xsl:for-each>
				</xsl:attribute>
				<xsl:attribute name="program">
          <xsl:value-of select="ancestor::program:program[position() = last()]/@name"/>
					<xsl:for-each select="ancestor::program:program[../@instance]">
              <xsl:value-of select="' '"/>
              <xsl:value-of select="@name"/>
							<xsl:value-of select="concat (':', ../@instance)"/>
					</xsl:for-each>
				</xsl:attribute>
        <xsl:apply-templates select="./program:excitatory/program:conception/program:intention/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:prediction/program:intention/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:input/program:premise" mode="input"/>
				<xsl:apply-templates select="./program:excitatory/program:command/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:perception/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:conception/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:prediction/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:landmark/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:input_operator/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:input_scope/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:other_operator/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:other_scope/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:transition/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:anomaly/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:reward/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:excitatory/program:check/program:premise" mode="excitatory"/>
				<xsl:apply-templates select="./program:inhibitory/program:command/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:perception/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:conception/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:prediction/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:landmark/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:other_operator/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:input_scope/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:input_operator/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:other_scope/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:transition/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:anomaly/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:reward/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:check/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:conception/program:intention/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:inhibitory/program:prediction/program:intention/program:premise" mode="inhibitory"/>
				<xsl:apply-templates select="./program:conclusion"/>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="program:conclusion">
		<xsl:element name="code:conclusion">
			<xsl:variable name="category">
        <xsl:variable name="test" select="local-name(../..)"/>
        <xsl:choose>
          <xsl:when test="contains($test,'_')">
            <xsl:value-of select="substring-after($test, '_')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$test"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
			<xsl:attribute name="category">
				<xsl:value-of select="$category"/>
			</xsl:attribute>
			<xsl:attribute name="type">
        <xsl:call-template name="type_index">
          <xsl:with-param name="category" select="$category"/>
          <xsl:with-param name="id" select="program:information/@typeId"/>
        </xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="program:information/@itemId"/>
			</xsl:attribute>
			<xsl:if test="program:information/@delay">
				<xsl:attribute name="delay">
					<xsl:value-of select="program:information/@delay"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="../parent::program:command">
				<xsl:apply-templates select=".//program:output"/>
				<xsl:if test="$multiplexer != 'no'">
					<xsl:element name="code:output">
						<xsl:attribute name="value">
							<xsl:value-of select="key('modelKey',./program:information/@model)/@number - 1"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:output">
		<xsl:element name="code:output">
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:premise" mode="input">
		<xsl:element name="code:premise">
			<xsl:attribute name="category">
				<xsl:value-of select="local-name (parent::*)"/>
			</xsl:attribute>
			<xsl:attribute name="property">
				<xsl:value-of select="'excitatory'"/>
			</xsl:attribute>
			<xsl:attribute name="type">
        <xsl:call-template name="type_index">
          <xsl:with-param name="category" select="local-name (parent::*)"/>
          <xsl:with-param name="id" select="program:information/@typeId"/>
        </xsl:call-template>
			</xsl:attribute>
			<xsl:apply-templates select=".//program:information" mode="input"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:information" mode="input">
		<xsl:element name="code:information">
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:premise" mode="excitatory">
    <xsl:variable name="category">
      <xsl:call-template name="category" />
    </xsl:variable>
		<xsl:element name="code:premise">
			<xsl:attribute name="category">
				<xsl:value-of select="$category"/>
			</xsl:attribute>   
			<xsl:attribute name="type">
        <xsl:call-template name="type_index">
          <xsl:with-param name="category" select="$category"/>
          <xsl:with-param name="id" select="program:information/@typeId"/>
        </xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="property">
				<xsl:value-of select="'excitatory'"/>
			</xsl:attribute>
			<xsl:apply-templates select="./program:information"/>
			<xsl:apply-templates select="./program:credibility"/>
			<xsl:apply-templates select="./program:timespan"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:premise" mode="inhibitory">
    <xsl:variable name="category">
      <xsl:call-template name="category" />
    </xsl:variable>
		<xsl:element name="code:premise">
			<xsl:attribute name="category">
				<xsl:value-of select="$category"/>
			</xsl:attribute>
			<xsl:attribute name="type">
        <xsl:call-template name="type_index">
          <xsl:with-param name="category" select="$category"/>
          <xsl:with-param name="id" select="program:information/@typeId"/>
        </xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="property">
				<xsl:value-of select="'inhibitory'"/>
			</xsl:attribute>
			<xsl:apply-templates select="./program:information"/>
			<xsl:apply-templates select="./program:credibility"/>
			<xsl:apply-templates select="./program:timespan"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:information">
		<xsl:element name="code:information">
			<xsl:attribute name="value">
				<xsl:value-of select="@itemId"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:credibility">
		<xsl:element name="code:credibility">
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:timespan">
		<xsl:element name="code:timespan">
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="inference_engine:* | knowledge_base:*">
		<xsl:element name="{concat('code:', local-name(.))}">
			<xsl:if test="@value">
				<xsl:attribute name="value">
					<xsl:value-of select="@value"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="knowledge_base:time_span_limit">
		<xsl:element name="{concat('code:', 'time_span_limit')}">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@value = 'auto'">
						<xsl:choose>
							<xsl:when test="string-length($maximum_of_timespan) != 0">
								<xsl:value-of select="$maximum_of_timespan"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="0"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$maximum_of_timespan &gt;= @value">
                <xsl:message terminate="no">
                  <xsl:value-of select="concat('Constraint Error : maximum of timespan > ', @value)"/>
                </xsl:message>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@value"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="knowledge_base:maximum_of_premises">
		<xsl:element name="{concat('code:', 'maximum_of_premises')}">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@value = 'auto'">
						<xsl:choose>
							<xsl:when test="$maximum_of_premises != 0">
								<xsl:value-of select="$maximum_of_premises"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="1"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$maximum_of_premises &gt; @value">
                <xsl:message terminate="no">
                  <xsl:value-of select="concat('Constraint Error : premises number > ', @value)"/>
                </xsl:message>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@value"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="knowledge_base:maximum_of_rules_by_type">
		<xsl:element name="{concat('code:', 'maximum_of_rules_by_type')}">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@value = 'auto'">
						<xsl:value-of select="$maximum_of_rules_by_type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$maximum_of_rules_by_type &gt; @value">
                <xsl:message terminate="no">
                  <xsl:value-of select="concat('Constraint Error : rules number by type > ', @value)"/>
                </xsl:message>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@value"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="knowledge_base:maximum_of_internal_events">
		<xsl:element name="{concat('code:', 'maximum_of_internal_events')}">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@value = 'auto'">
						<xsl:choose>
							<xsl:when test="$maximum_of_internal_events != ''">
								<xsl:value-of select="$maximum_of_internal_events"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="1"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$maximum_of_internal_events &gt; @value">
                <xsl:message terminate="no">
                  <xsl:value-of select="concat('Constraint Error : a internal events number in a condition > ', @value)"/>
                </xsl:message>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@value"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*"/>
	<xsl:template name="type_index">
		<xsl:param name="category"/>
		<xsl:param name="id"/>
		<xsl:choose>
			<xsl:when test="$category = 'input'">
        <xsl:value-of select="$id"/>
			</xsl:when>
			<xsl:when test="$category = 'command'">
				<xsl:value-of select="$id + $last_input"/>
			</xsl:when>
			<xsl:when test="$category = 'perception'">
				<xsl:value-of select="$id + $last_command"/>
			</xsl:when>
			<xsl:when test="$category = 'conception'">
				<xsl:value-of select="$id + $last_perception"/>
			</xsl:when>
			<xsl:when test="$category = 'prediction'">
				<xsl:value-of select="$id + $last_conception"/>
			</xsl:when>
			<xsl:when test="$category = 'landmark'">
					<xsl:value-of select="$id + $last_prediction"/>
			</xsl:when>
			<xsl:when test="$category = 'operator'">
					<xsl:value-of select="$id + $last_landmark"/>
			</xsl:when>
			<xsl:when test="$category = 'scope'">
					<xsl:value-of select="$id + $last_operator"/>
			</xsl:when>
			<xsl:when test="$category = 'transition'">
				<xsl:value-of select="$id + $last_scope"/>
      </xsl:when>
			<xsl:when test="$category = 'reward'">
        <xsl:value-of select="$id + $last_transition"/>
			</xsl:when>
			<xsl:when test="$category = 'anomaly'">
				<xsl:value-of select="$id + $last_reward"/>
			</xsl:when>
			<xsl:when test="$category = 'check'">
				<xsl:value-of select="$id + $last_anomaly"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
  <xsl:template name="maxRulesByType">
    <xsl:param name="n"/>
    <xsl:param name="declaration"/>
    <xsl:param name="max"/>
    <xsl:variable name="nbrRules" select="count(//program:rule/program:conclusion/program:information[@type=$declaration[position()=$n]/@type and @model=$declaration[position()=$n]/@model and local-name(parent::*/parent::*/parent::*)=$declaration[position()=$n]/@category])"/>
    <xsl:choose>
    <xsl:when test="$n + 1 &gt; count($declaration)">
      <xsl:value-of select="$max"/>
    </xsl:when>
    <xsl:when test="$nbrRules &gt; $max">
      <xsl:call-template name="maxRulesByType">
        <xsl:with-param name="n" select="$n + 1"/>
        <xsl:with-param name="declaration" select="$declaration"/>
        <xsl:with-param name="max" select="$nbrRules"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="maxRulesByType">
        <xsl:with-param name="n" select="$n + 1"/>
        <xsl:with-param name="declaration" select="$declaration"/>
        <xsl:with-param name="max" select="$max"/>
      </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="category">
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="local-name (parent::*) = 'intention'">
          <xsl:value-of select="local-name (parent::*/parent::*)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="local-name (parent::*)"/>
				</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
      <xsl:choose>
        <xsl:when test="contains($name, '_')">
          <xsl:value-of select="substring-after($name, '_')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$name"/>
				</xsl:otherwise>
      </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
