//  Copyright (2010-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, version 2 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

var h = 167;

var pointsscatterSVG;

var progressSize;
var view;

function selectUnit(){
	nomoSDK.selectPointsUnit();
}

function openUnit(name) {
	document.getElementById ("unitSelection").value = name;
	if (!hasUnit)
		showControls();
}

function reloadUnit(){
	nomoSDK.reloadPointsUnit();
}

function showControls() {
	hasUnit = true;
	var unitDiv = document.getElementById ("unit");
	unitDiv.style.webkitTransitionDuration = "1s";
	unitDiv.style.right = "0px";
	var unitReloading = document.getElementById ("unitReloading");
	unitReloading.style.marginLeft = "0px";
	unitReloading.style.webkitTransitionProperty = "margin-left";
	unitReloading.style.webkitTransitionDelay = "0.3s";
	unitReloading.style.webkitTransitionDuration = "0.7s";
	unitReloading.style.pointerEvents = "all";
	var pointsDiv = document.getElementById ("points");
	pointsDiv.style.webkitTransitionDuration = "1s";
	pointsDiv.style.left = "0px";
	var pointsReloading = document.getElementById ("pointsReloading");
	pointsReloading.style.marginRight = "0px";
	pointsReloading.style.webkitTransitionProperty = "margin-right";
	pointsReloading.style.webkitTransitionDelay = "0.3s";
	pointsReloading.style.webkitTransitionDuration = "0.7s";
	pointsReloading.style.pointerEvents = "all";
	var actionDiv = document.getElementById ("action")
	actionDiv.style.opacity = "1";
	actionDiv.style.webkitTransitionDuration = "1s";
	pointsscatterSVG.style.webkitTransitionDuration = "1s";
	h=167;
	pointsscatterSVG.style.height = (window.innerHeight - h) + "px";
	slabs.setAttribute("class", "");
}

function selectPoints(){
	nomoSDK.selectPoints();
}

function end (){
	document.getElementById ("starting").onclick = start;
	document.getElementById ("starting").name = 'start';
	document.getElementById ("controls").setAttribute("class", "box");
	document.getElementById("fileFlag").options[2].selected = "selected";
	setProgressBar(101);
}

window.onload = function ()
{
	document.getElementById ("unitSelection").onclick = selectUnit;
	document.getElementById ("unitReloading").onclick = reloadUnit;
	document.getElementById ("pointsSelection").onclick = selectPoints;
	document.getElementById ("pointsReloading").onclick = reloadData;
	progressSize = document.getElementById ("progressSize");
	progressVal = document.getElementById ("progressVal");
	progressBar = document.getElementById ("progressBar");
	pointsscatterSVG = document.getElementsByTagNameNS ("http://www.w3.org/2000/svg", "svg")[0];
	pointsscatterSVG.getElementsByTagNameNS ("http://www.w3.org/2000/svg", "rect")[0].style.display = 'none';
	initializeForm ();
	var forms = document.getElementsByTagName ("form");
	for (i in forms)
	{
		forms[i].action = action;
	}
	if (!hasUnit)
	{
		h=37;
		document.getElementById ("unit").style.right = "-55px";
		document.getElementById ("unitReloading").style.marginLeft = "10px";
		document.getElementById ("unitReloading").style.pointerEvents = "none";
		document.getElementById ("points").style.left = "-55px";
		document.getElementById ("pointsReloading").style.marginRight = "10px";
		document.getElementById ("pointsReloading").style.pointerEvents = "none";
		document.getElementById ("action").style.webkitTransitionDuration = "0s";
		document.getElementById ("action").style.opacity = "0";
	}
	pointsscatterSVG.style.height = (window.innerHeight - h) + "px";
	pointsscatterSVG.style.width = "100%";

	window.onresize = function () {
	pointsscatterSVG.style.width = "100%";
	pointsscatterSVG.style.webkitTransitionDuration = "0s";
	pointsscatterSVG.style.height = (window.innerHeight - h) + "px";
	}
	
	view = new viewControl (pointsscatterSVG);
	view.initialize();
}

function refresh () {
	var pointsscatter = document.getElementById ("pointsscatter");
	var oldPoints = pointsscatter.getElementsByTagName("svg")[0];
	var newPoints = document.importNode(loadXML("../../points.svg").firstChild, true);
	for (i in oldPoints.attributes)
	{ 	
		newPoints.setAttribute(oldPoints.attributes[i].name,oldPoints.attributes[i].value);
	}
	newPoints.style = pointsscatterSVG.style;
	newPoints.getElementsByTagNameNS ("http://www.w3.org/2000/svg", "rect")[0].style.display = 'none';
	pointsscatter.replaceChild(newPoints, oldPoints);
	pointsscatterSVG = newPoints;
	view.refresh(pointsscatterSVG);
	oldPoints = null;
}

function start (){
	if (document.getElementById("stepsNumber").value == "1")
		document.getElementById ("starting").onclick = "";
	else
		document.getElementById ("starting").onclick = pause;
	document.getElementById ("starting").name = 'pause';
	document.getElementById ("controls").setAttribute("class", "box pause one"+document.getElementById("stepsNumber").value);
	nomoSDK.startPoints ();
}