--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Accurately;

with Nomo.Interpreter.External_Messages.Premises;

with Nomo.Interpreter.Premises_Index.Arrays;

with Nomo.Internal_Messages.Conclusions;

with Nomo.Interpreter.Types_Index.Ranges;

package Nomo.Interpreter.Storages.Reading is

   use Numerics.Accurately;
   use Numerics.Fitting;
   use Types_Index.Ranges;
   use Internal_Messages.Conclusions;
   use External_Messages;
   use External_Messages.Premises;
   use Premises_Index.Arrays;
   use Premises_Index.Premises_Index_Instance;

   function Get_Conclusion_Type (This : in Full_Rule_Storage) return Internal_Type_Index;

   function Get_Id (This : in Full_Rule_Storage) return Positive;

   function Get_Internal_Conclusion (This : in Full_Rule_Storage) return not null access constant Internal_Conclusion;

   function Get_Internal_Condition (This : in Full_Rule_Storage) return not null access constant Internal_Premises;

   function Get_Internal_Condition_Types (This : in Full_Rule_Storage) return not null access constant Internal_Premises_Types;

   function Get_Internal_Condition_Properties (This : in Full_Rule_Storage) return not null access constant Internal_Premises_Properties;

   function Get_Internal_Premises_Number (This : in Full_Rule_Storage) return Premise_Index;

   function Get_Fitting_Nbr (This : in Full_Rule_Storage) return Count;

   function Get_Relevance (This : in Full_Rule_Storage) return Real_Accurately_0_To_1;

   function Get_External_Conclusion (This : in Full_Rule_Storage) return not null access constant External_Message;

   function Get_External_Condition (This : in Full_Rule_Storage) return not null access constant External_Premise;

   function Get_External_Condition_Type_Index (This : in Full_Rule_Storage) return Input_Type_Index;

end Nomo.Interpreter.Storages.Reading;
