--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

package body Nomo.Interpreter.Rules_Base.Delayed is

   procedure Add_Score (This          : in out Delayed_Rule;
                        Score         : in Positive_Real;
                        Is_Noteworthy : out Boolean) is
   begin
      This.Scores_Sum := This.Scores_Sum + Score;
      Is_Noteworthy := Score > This.Score_Max;
      if Is_Noteworthy then
         This.Score_Max := Score;
      end if;
   end Add_Score;

   Reimbursement_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Reimbursement_Rate;

   procedure Adjust (This           : in out Delayed_Rule;
                     Is_Maximizable : out Boolean) is
   begin
      Is_Maximizable := This.Scores_Sum /= 0.0;
      if Is_Maximizable then
         This.Expectancy_Factor := Real_Accurately_0_To_1(This.Score_Max / This.Scores_Sum) * (1.0 - This.Relevance);
         Adjust (Rule_Base (This), Reimbursement_Rate);
      end if;
   end Adjust;

   procedure Reset (This : in out Delayed_Rule) is
   begin
      This.Scores_Sum := 0.0;
      This.Score_Max := 0.0;
   end Reset;

   Tax_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Tax_Rate;

   procedure Update_Relevance (This : in out Delayed_Rule) is
   begin
      This.Relevance := This.Relevance - Tax_Rate * Real_Accurately_0_To_1((1.0 - This.Relevance) * This.Relevance);
   end Update_Relevance;

end Nomo.Interpreter.Rules_Base.Delayed;
