--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Event_Memory.External.Plant;

package body Nomo.Interpreter.Plant.External_Pointer is

   This           : Target;
   Is_Active      : Boolean := False;
   Event_Position : External_Event_Index;
   Scope_Index    : Positive;

   procedure Cancel is
   begin
      Is_Active := False;
   end Cancel;

   function Get_Event_Position return External_Event_Index is
   begin
      return Event_Position;
   end Get_Event_Position;

   procedure Get_Target (Chunck_Target : out Target) is
   begin
      Chunck_Target.Arrival_Time := This.Arrival_Time;
      Chunck_Target.Capture_Time := This.Capture_Time;
      Chunck_Target.Index := This.Index;
   end Get_Target;

   function Is_Expired (T : in Positive_Time) return Boolean is
   begin
      return This.Is_Expired (T);
   end Is_Expired;

   procedure Set_Scope (Information : in Positive_Integer) is
   begin
      Is_Active := True;
      Scope_Index := Positive(Information);
   end Set_Scope;

   procedure Update_Position (T : in Positive_Time) is
     use Event_Memory.External.Plant;
   begin
      if Is_Active then
         Is_Active := False;
         This.Capture_Time := T;
         Get_Current_Event (Scope_Index, This.Index, This.Arrival_Time, Event_Position);
      end if;
   end Update_Position;

end Nomo.Interpreter.Plant.External_Pointer;
