--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Premises.Loading;

package body Nomo.Internal_Messages.Premises.Plant is

   procedure Adjust_Trend (This        : in out Internal_Premise;
                           Fitting_Nbr : in Count) is
   begin
      if This.Time_Span_Tolerance /= Positive_Infinity and This.Time_Span_Tolerance /= Zero_Plus then
         This.Time_Span_Trend.Values_Sum := Time (This.Time_Span) * Time (Fitting_Nbr);
         This.Time_Span_Trend.Squares_Sum := Time (This.Time_Span) ** 2 + Time (This.Time_Span_Tolerance)* Time (Fitting_Nbr);
      end if;
      if This.Credibility_Tolerance /= Positive_Infinity and This.Credibility_Tolerance /= Zero_Plus then
         This.Credibility_Trend.Values_Sum := Long_Real (This.Credibility * Real (Fitting_Nbr));
         This.Credibility_Trend.Squares_Sum := Long_Real (This.Credibility ** 2 + This.Credibility_Tolerance * Real (Fitting_Nbr));
      end if;
   end Adjust_Trend;

   procedure Set (This                  : out Internal_Premise;
                  Information           : in Positive_Integer;
                  Information_Tolerance : in Boolean;
                  Time_Span             : in Time_Interval;
                  Time_Span_Tolerance   : in Strictly_Positive_Real;
                  Credibility           : in Real_0_To_1;
                  Credibility_Tolerance : in Strictly_Positive_Real) is
      use Premises.Loading;
   begin
      Set (This,
           Information,
           Information_Tolerance,
           Time_Span,
           Time_Span_Tolerance,
           Credibility,
           Credibility_Tolerance,
           1);
   end Set;

   procedure Set (This   : out Internal_Premise;
                  Source : in Internal_Premise) is
   begin
      This.Information := Source.Information;
      This.Time_Span := Source.Time_Span;
      This.Credibility := Source.Credibility;
      This.Tolerance := Source.Tolerance;
      This.Time_Span_Tolerance := Source.Time_Span_Tolerance;
      This.Credibility_Tolerance := Source.Credibility_Tolerance;
      This.Specificity_Log := Source.Specificity_Log;
   end Set;

   procedure Set_Time_Span (This      : in out Internal_Premise;
                            Time_Span : in Time_Interval) is
   begin
      This.Time_Span := Time_Span;
   end Set_Time_Span;

end Nomo.Internal_Messages.Premises.Plant;
