//  Copyright (2010-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, version 2 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

var nomoNavigation = new(function(){

	var html;
	var tree;
	var objSelected;
	var isActive;
	
	this.initialize = function(){
		this.html = document.getElementById("tree");
		tree = {"core" : {
					"animation" : 250,
					"open_parents" : false
				},
				"ui" : {
					"select_limit" : -1,
					"selected_parent_close" : "select_parent",
					"select_multiple_modifier" : "ctrl",
				},
				"crrm" : { 
					"move" : {
						"default_position" : "first",
						"check_move" : function (m) {
							var po = this._get_parent(m.o);
							var pr = this._get_parent(m.r);
							if (po == -1 && pr == -1)
								return true;
							else if (po != -1 && pr != -1){
								var ido = m.o.attr("id").split('-');
								var idr = m.r.attr("id").split('-');
								if (ido[0] == idr[0]){
									if (ido[0][0]=='p')
										return ((ido[1] == 'rule' || ido[1] == 'scheme') && (idr[1] == 'rule' || idr[1] == 'scheme')) || (idr[1] == ido[1]);
									else if (ido[0][0]=='m' && ido[1] != 'base' && ido[1] != 'include')
										return po.attr("id").split('-').length == 1 && pr.attr("id").split('-').length == 1;
									else
										return false;
								}
								else
									return false;
							}
							else
								return false;
						//	if (this._get_type(p) == 'model');
						/*
							if(m.o.attr("id").split('-')[2]=="cursor" | m.o.attr("id").split('-')[2]=="operator")return false;
							if(!p) return false;
							p = p == -1 ? this.get_container() : p;
							if(p === m.np) return true;
							if(p[0] && m.np[0] && p[0] === m.np[0]) 
							{
								return true;
							}
							return false;*/
						}
					}
				},
				"dnd" : {
					"drop_target" : false,
					"drag_target" : false
				},
				"themes" : { 
					"url" : "../share/lib/jstree/theme/style.css"
				},
				"types" : {
					"valid_children" : [ "program", "unit", "knowledge", "model", "engine" ],
					"types" : {
						"unit" : {
							"icon" : { 
								"image" : "icons/unit.png",
							},
							"valid_children" : [ "knowledge", "program", "engine" ]
						},
						"knowledge" : {
							"icon" : { 
								"image" : "icons/base.png",
							},
							"valid_children" : [ "none" ]
						},
						"engine" : {
							"icon" : { 
								"image" : "icons/engine.png",
							},
							"valid_children" : [ "none" ]
						},
						"model" : {
							"icon" : { 
								"image" : "icons/model.png",
							},
							"valid_children" : ["base", "perception", "command", "conception", "prediction", "landmark", "reward", "plant_structure" ]
						},
						"base" : {
							"icon" : { 
								"image" : "icons/model.png",
							},
							"valid_children" : [ "none" ]
						},
						"program" : {
							"icon" : { 
								"image" : "icons/program.png"
							},
							"valid_children" : [ "scheme", "perception_rule", "conception_rule", "command_rule", "prediction_rule", "check_rule", "landmark_rule", "reward_rule", "anomaly_rule", "scope_rule", "operator_rule", "transition_rule", "model_instance", "program_instance", "formalism", "macro"]
						},
						"scheme" : {
							"icon" : { 
								"image" : "icons/scheme.png"
							},
							"valid_children" : [ "scheme", "perception_rule", "conception_rule", "command_rule", "prediction_rule", "check_rule", "landmark_rule", "reward_rule", "anomaly_rule", "scope_rule", "operator_rule", "transition_rule"]
						},
						"rule" : {
							"icon" : { 
								"image" : "icons/rule.png"
							},
							"valid_children" : [ "none" ]
						},
						"formalism" : {
							"icon" : { 
								"image" : "icons/formalism.png"
							},
							"valid_children" : [ "none" ]
						},
						"macro" : {
							"icon" : { 
								"image" : "icons/macro.png"
							},
							"valid_children" : [ "none" ]
						},
						"model_instance" : {
							"icon" : { 
								"image" : "icons/model.png"
							},
							"valid_children" : [ "none" ]
						},
						"program_instance" : {
							"icon" : { 
								"image" : "icons/program.png"
							},
							"valid_children" : [ "none" ]
						},
						"perception_rule" : {
							"icon" : { 
								"image" : "icons/perception.png"
							},
							"valid_children" : [ "none" ]
						},
						"perception" : {
							"icon" : { 
								"image" : "icons/perception.png"
							},
							"valid_children" : [ "input", "command", "conception", "prediction", "reward" ]
						},
						"input" : {
							"icon" : { 
								"image" : "icons/input.png"
							},
							"valid_children" : [ "none" ]
						},
						"command_rule" : {
							"icon" : { 
								"image" : "icons/command.png"
							},
							"valid_children" : [ "none" ]
						},
						"command" : {
							"icon" : { 
								"image" : "icons/command.png"
							},
							"valid_children" : [ "conception", "reward" ]
						},
						"conception_rule" : {
							"icon" : { 
								"image" : "icons/conception.png"
							},
							"valid_children" : [ "none" ]
						},
						"conception" : {
							"icon" : { 
								"image" : "icons/conception.png"
							},
							"valid_children" : [ "conception", "reward", "prediction" ]
						},
						"prediction_rule" : {
							"icon" : { 
								"image" : "icons/prediction.png"
							},
							"valid_children" : [ "none" ]
						},
						"prediction" : {
							"icon" : { 
								"image" : "icons/prediction.png"
							},
							"valid_children" : [ "conception", "reward", "landmark", "check" ]
						},
						"check_rule" : {
							"icon" : { 
								"image" : "icons/check.png"
							},
							"valid_children" : [ "none" ]
						},
						"check" : {
							"icon" : { 
								"image" : "icons/check.png"
							},
							"valid_children" : [ "none" ]
						},
						"landmark_rule" : {
							"icon" : { 
								"image" : "icons/landmark.png"
							},
							"valid_children" : [ "none" ]
						},
						"landmark" : {
							"icon" : { 
								"image" : "icons/landmark.png"
							},
							"valid_children" : [ "conception", "reward" ]
						},
						"reward_rule" : {
							"icon" : { 
								"image" : "icons/reward.png"
							},
							"valid_children" : [ "none" ]
						},
						"reward" : {
							"icon" : { 
								"image" : "icons/reward.png"
							},
							"valid_children" : [ "conception", "reward" ]
						},
						"plant_structure" : {
							"icon" : { 
								"image" : "icons/plant.png"
							},
							"valid_children" : [ "transition", "anomaly",  "operator", "scope", "reward"]
						},
						"transition_rule" : {
							"icon" : { 
								"image" : "icons/transition.png"
							},
							"valid_children" : [ "none" ]
						},
						"transition" : {
							"icon" : { 
								"image" : "icons/transition.png"
							},
							"valid_children" : [ "none" ]
						},
						"anomaly_rule" : {
							"icon" : { 
								"image" : "icons/anomaly.png"
							},
							"valid_children" : [ "none" ]
						},
						"anomaly" : {
							"icon" : { 
								"image" : "icons/anomaly.png"
							},
							"valid_children" : [ "none" ]
						},
						"scope_rule" : {
							"icon" : { 
								"image" : "icons/scope.png"
							},
							"valid_children" : [ "none" ]
						},
						"scope" : {
							"icon" : { 
								"image" : "icons/scope.png"
							},
							"valid_children" : [ "none" ]
						},
						"operator_rule" : {
							"icon" : { 
								"image" : "icons/operator.png"
							},
							"valid_children" : [ "none" ]
						},
						"operator" : {
							"icon" : { 
								"image" : "icons/operator.png"
							},
							"valid_children" : [ "none" ]
						}
					}
				},
				"plugins" : ["themes", "html_data", "core", "ui", "types", "crrm", "dnd", "cookies"]
			};
		}

	this.update = function(){
		var id = this.html.firstChild.lastChild.previousSibling.id;
		if ($.cookie("jstree_open")){
			if ($.cookie("jstree_open").toString().search(id)==-1){
				$.cookie("jstree_open", $.cookie("jstree_open").toString()+',#'+id, {});
				$.cookie("jstree_select", '#'+id, {});
			}
		}
		else {
			$.cookie("jstree_open", '#'+id, {});
			$.cookie("jstree_select", '#'+id, {});
		}
		$("#tree").jstree(tree)
			.bind("loaded.jstree", function (event, data) {
				if(nomoWorkspace.isInitialized)
					setTimeout("nomoWorkspace.addBind($('#tree'))",0);
				else
					setTimeout("nomoWorkspace.initialize()",0);
			})
		/*	.bind("after_open.jstree after_close.jstree", function (e) {
			})
			.bind("move_node.jstree", function (event, data) {
			})*/;
	}
	
 });