cd %~dp0
if exist nomointerpreter.so del nomointerpreter.so
if exist nomointerpreter.dll del nomointerpreter.dll

cd ../../src/nomointerpreter

echo Build dynamic library nomointerpreter

gnatmake -v -z nomo-interpreter-kernel.adb -I. -I../standard_random -cargs -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O2 -gnatVn -gnatp -gnatn -funroll-loops -bargs -n -x -v -Lnomointerpreter -largs -s -g -Wl -fPIC --gc-sections
REM debug: gnatmake -v -z nomo-interpreter-kernel.adb -I. -I../standard_random -cargs -g -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O0 -gnatVn -g -gnato -fstack-check -gnatE -fcallgraph-info=su,da -gnata

gnatbind -n -x nomo-interpreter-kernel.ali -Lnomointerpreter
gnatlink -g -mdll -s -o nomointerpreter.dll nomo-interpreter-kernel.ali -Xlinker --base-file=nomointerpreter.base
dlltool --dllname nomointerpreter.dll --base-file nomointerpreter.base --output-exp nomointerpreter.exp --def nomointerpreter.def
gnatlink -g -mdll -s -o nomointerpreter.dll nomo-interpreter-kernel.ali -Xlinker --base-file=nomointerpreter.base nomointerpreter.exp
dlltool --dllname nomointerpreter.dll --base-file nomointerpreter.base --output-exp nomointerpreter.exp --def nomointerpreter.def
gnatlink -g -mdll -s -o nomointerpreter.dll nomo-interpreter-kernel.ali -Xlinker nomointerpreter.exp

echo Build a Microsoft-style import library
set PATH=../../bin;%PATH%
lib -machine:IX86 -def:nomointerpreter.def -out:nomointerpreter.lib >save.txt

del b~nomo-interpreter-kernel.ads
del b~nomo-interpreter-kernel.adb
del b~nomo-interpreter-kernel.ci
del nomointerpreter.base
del nomointerpreter.exp
del save.txt
del *.o
del *.ali
del *.ci
del *.cwsi
del *.cgpr
del *.exe

mv nomointerpreter.lib ../../lib/
mv nomointerpreter.dll ../../build/nomointerpreter/

cd ../../build/nomotools/helloworld
if not exist HelloWorld.seed call helloworld.bat
copy HelloWorld.seed ..\..\nomointerpreter\helloworld
cd ../../nomointerpreter
