--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;

with Ada.Directories;

with Ada.Exceptions;

with Nomo.Compiler;

with Nomo.Converter.Text;

package body Nomotools is

   procedure Error (Message : in String);

   procedure Compile (Code_Path : in Interfaces.C.Strings.chars_ptr;
                      Length    : in Interfaces.C.size_t) is
   begin
      Nomo.Compiler.Compile (Interfaces.C.Strings.Value (Code_Path, Length));
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end Compile;

   procedure FR_To_Seed (Log_Path         : in Interfaces.C.Strings.chars_ptr;
                         Log_Path_Length  : in Interfaces.C.size_t;
                         Seed_Path        : in Interfaces.C.Strings.chars_ptr;
                         Seed_Path_Length : in Interfaces.C.size_t;
                         Crush            : in Interfaces.C.short) is
      use Interfaces.C;
   begin
      Nomo.Converter.FR_To_Seed (Interfaces.C.Strings.Value (Log_Path, Log_Path_Length),
                                 Interfaces.C.Strings.Value (Seed_Path, Seed_Path_Length),
                                 Crush /= 0);
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end FR_To_Seed;

   procedure PR_To_CSV (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t) is
   begin
      Nomo.Converter.Text.PR_To_CSV (Interfaces.C.Strings.Value (Log_Path, Length));
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end PR_To_CSV;

   procedure FR_To_CSV (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t) is
   begin
      Nomo.Converter.Text.FR_To_CSV (Interfaces.C.Strings.Value (Log_Path, Length));
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end FR_To_CSV;

   procedure PR_To_XML (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t) is
   begin
      Nomo.Converter.Text.PR_To_XML (Interfaces.C.Strings.Value (Log_Path, Length));
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end PR_To_XML;

   procedure FR_To_XML (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t) is
   begin
      Nomo.Converter.Text.FR_To_XML (Interfaces.C.Strings.Value (Log_Path, Length));
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end FR_To_XML;

   procedure PR_To_DB (Log_Path   : in Interfaces.C.Strings.chars_ptr;
                       Log_Length : in Interfaces.C.size_t;
                       DB_Path    : in Interfaces.C.Strings.chars_ptr;
                       DB_Length  : in Interfaces.C.size_t;
                       Create     : in Interfaces.C.int) is
      Create_DB : constant Boolean := Boolean'Val(Create);
   begin
      Nomo.Converter.Text.PR_To_DB (Interfaces.C.Strings.Value (Log_Path, Log_Length), Interfaces.C.Strings.Value (DB_Path, DB_Length), Create_DB );
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end PR_To_DB;

   procedure FR_To_DB (Log_Path   : in Interfaces.C.Strings.chars_ptr;
                       Log_Length : in Interfaces.C.size_t;
                       DB_Path    : in Interfaces.C.Strings.chars_ptr;
                       DB_Length  : in Interfaces.C.size_t;
                       Create     : in Interfaces.C.int) is
      Create_DB : constant Boolean := Boolean'Val (Create);
   begin
      Nomo.Converter.Text.FR_To_DB (Interfaces.C.Strings.Value (Log_Path, Log_Length), Interfaces.C.Strings.Value (DB_Path, DB_Length), Create_DB);
   exception
      when Event : others =>
         Error (Ada.Exceptions.Exception_Information (Event));
   end FR_To_DB;

   procedure Error (Message : in String) is
      use Ada.Text_IO;
      File_Name : constant String := "nomotools.err";
      Error_File : File_Type;
   begin
      if Ada.Directories.Exists (File_Name) then
         Open (Error_File , Append_File, File_Name);
      else
         Create (Error_File , Append_File, File_Name);
      end if;
      Put_Line (Error_File, Message);
   end Error;

end Nomotools;
