--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;

with Nomo.Type_Categories;
use Nomo.Type_Categories;

with Nomo.Numerics.Times;

generic
   with function Get_Category (I : in Internal_Type_Index) return Type_Category;
package Nomo.Gen_Premises_Index.Arrays.Printing is

   use Ada.Text_IO;

   package CVS is

      procedure Put_Header (File : in out File_Type);

      procedure Put (File         : in out File_Type;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index);

   end CVS;

   package XML is

      procedure Put (File         : in out File_Type;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index);

   end XML;

   package DB is

      procedure Put (File         : in out File_Type;
                     T            : in Numerics.Times.Time;
                     Rule_Id      : in Positive;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index);

   end DB;

end Nomo.Gen_Premises_Index.Arrays.Printing;
