//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef WORLDSQUAREUI_H
#define WORLDSQUAREUI_H

#include <libxml/parser.h>

#ifdef __cplusplus
extern "C" {
#endif

void initWorldSquareXML ();

int readWorldSquareXML (const char* filename);

void updateWorldSquareXML (const char* filename);

void resetWorldSquareXML();

void saveWorldSquareXML (const char* filename);

xmlDocPtr getWorldSquareXML();

void addAgentWorldSquareXML (const char* on, const char* direction, const char* spheresNbr);

void moveAgentWorldSquareXML (const char* on, const char* at);

void addSphereWorldSquareXML (const char* on);

void addSlabWorldSquareXML (const char* x, const char* y, const char* hue);

void setHueSlabWorldSquareXML (const char* id, const char* hue);

const char* getSpheresNbrWorldSquareXML (const char* id);

void setSpheresNbrWorldSquareXML (const char* id, const char* spheresNbr);

void suppAllWorldSquareXML (const char* id);

void suppSlabWorldSquareXML (const char* id);

void suppAgentWorldSquareXML (const char* on);

void suppSphereWorldSquareXML (const char* on);

void freeWorldSquareXML ();

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // WORLDSQUAREUI_H
