//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#include <QtGui/QApplication>
#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QSettings>
#include <QTextCodec>
#include <QDir>

#include "mainwindow.h"

#include <qtsingleapplication.h>

#if WIN32
    #pragma comment(linker, "/SUBSYSTEM:windows /ENTRY:mainCRTStartup")
#endif
int main(int argc, char *argv[])
{
   QtSingleApplication application(argc, argv);

    if (argc > 1)
        if (application.sendMessage(QString(argv[1])))
            return 0;
    if (argc == 1)
        if (application.sendMessage(""))
            return 0;

    QTextCodec* textCode = QTextCodec::codecForName("UTF-8");
    QTextCodec::setCodecForTr(textCode);
    QTextCodec::setCodecForCStrings (textCode);
    QTextCodec::setCodecForLocale (textCode);
    QCoreApplication::setOrganizationName("nomoSeed");
    QCoreApplication::setOrganizationDomain("nomoseed.org");
    QCoreApplication::setApplicationName("nomoSDK");
    QDir::setCurrent(QCoreApplication::applicationDirPath()); /* A Commenter pour developper*/

    QPalette P;
    P.setColor(QPalette::Highlight,QColor(155,155,155, 200));
    application.setPalette(P);

    QSettings settings;
    QString language = settings.value("Locale").toString();
    if (language.isEmpty()){
        language = QLocale::system().name();
        settings.setValue("Locale", language);
    }

    QTranslator Qt_translator;
    Qt_translator.load(QString("qt_")+ language , QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    application.installTranslator(&Qt_translator);

    QTranslator SDK_translator;
    SDK_translator.load(QString("translations/nomoSDK_")+ language);
    application.installTranslator(&SDK_translator);
    application.setStyleSheet("QToolTip { opacity: 200; }");
    QString arg = "";
    if (argc > 1)
        arg = QString(argv[1]);
    MainWindow mainWindow(QLocale(language), arg, 0);

    application.setActivationWindow(&mainWindow);

    QObject::connect(&application, SIGNAL(messageReceived(const QString)), &mainWindow, SLOT(openProject(const QString)));

    if (argc == 1)
        mainWindow.show();

    return application.exec();
}
