--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>;

with Nomo.Rule_Storages_IO;

package body Nomo.Reader.Gen_Rule_Storages is

   package Local_Rule_Storages_IO is new Rule_Storages_IO.Gen_Bytes (Rule_Storage'Size);
   use Local_Rule_Storages_IO;

   procedure Get_Storage (I       : in Positive;
                          Storage : out Rule_Storage) is
      Buffer : Bytes;
      for Buffer'Address use Storage'Address;
   begin
      Bytes'Read (Reader.Get_Rule_Stream (I), Buffer);
   end Get_Storage;

end Nomo.Reader.Gen_Rule_Storages;
