--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;

with Nomo.Interpreter.Conditions_Base;

private with Nomo.Interpreter.Premises_Index;

private package Nomo.Interpreter.Reward_Conditions is

   use Conditions_Base;
   use Numerics.Accurately;
   use Numerics.Times;

   type Reward_Condition is new Condition_Base with private;

   procedure Evaluate (This  : in out Reward_Condition);

   procedure Evaluate (This  : in out Reward_Condition;
                       Shift : in Real_Accurately);

   function Get_First_Landmark (This : in Reward_Condition) return Positive_Time_Interval;

   function Get_Second_Landmark (This : in Reward_Condition) return Positive_Time_Interval;

private

   use Premises_Index.Premises_Index_Instance;

   type Reward_Condition is new Condition_Base with record
      First_Landmark  : Premise_Index;
      Second_Landmark : Premise_Index;
   end record;

end Nomo.Interpreter.Reward_Conditions;
