--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Premises.Initialization;

package body Nomo.Interpreter.Premises_Index.Arrays.Setting is

   procedure Set (This            : out Internal_Premises;
                  Premises        : in Internal_Premises;
                  Premises_Number : in Premise_Index) is
      use Nomo.Internal_Messages.Premises.Initialization;
   begin
      for I in 1..Premises_Number loop
         Set (This (I), Premises (I));
      end loop;
   end Set;

   procedure Set (This    : out Internal_Premises;
                  I       : in Premise_Index;
                  Premise : in Internal_Messages.Premises.Internal_Premise) is
      use Nomo.Internal_Messages.Premises.Initialization;
   begin
      Set (This (I), Premise);
   end Set;


   procedure Set (This            : out Internal_Premises_Types;
                  Premises_Type   : in Internal_Premises_Types;
                  Premises_Number : in Premise_Index) is
      use Nomo.Internal_Messages.Premises.Initialization;
   begin
      for I in 1..Premises_Number loop
         This (I) := Premises_Type (I);
      end loop;
   end Set;

   procedure Set (This          : out Internal_Premises_Types;
                  I             : in Premise_Index;
                  Internal_Type : in Types_Index.Ranges.Internal_Type_Index) is
   begin
      This (I) := Internal_Type;
   end Set;

   procedure Set (This     : out Internal_Premises_Properties;
                  I        : in Premise_Index;
                  Property : in Premise_Properties.Premise_Property) is
   begin
      This (Property) := I;
   end Set;

end Nomo.Interpreter.Premises_Index.Arrays.Setting;
