--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Clusters_Base.Initialization;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Initialization);

package body Nomo.Interpreter.Predictions_Clusters.Loading is

   use Internal_Messages.Conclusions.Delayed.Predictive;

   function Get_Prediction (This        : in Predictions_Cluster;
                            Information : in Positive_Integer) return access Predictive_Conclusion is
      use Pointer;
      use Local_Loading;
      Answer : Predictive_Conclusion_Ptr := null;
   begin
      if Get_Prediction (Cluster_Base (This), Information) /= null then
         Get_Conclusion (Get_Prediction (Cluster_Base (This), Information).all, Answer);
      end if;
      return Answer;
   end Get_Prediction;

   function Get_Last_Prediction (This : in Predictions_Cluster) return not null access Predictive_Conclusion is
      use Pointer;
      Answer : Predictive_Conclusion_Ptr;
   begin
      Get_Conclusion (This.Last_Loaded.all, Answer);
      return Answer;
   end Get_Last_Prediction;

   package Local_Initialization is new Predictions_Clusters_Base.Initialization;

   procedure Initialize (This            : in out Predictions_Cluster;
                         Prediction_Type : in Prediction_Type_Index) is
      use Local_Initialization;
   begin
      This.Prediction_Type := Prediction_Type;
      Initialize (Cluster_Base (This));
   end Initialize;

   function Has_Space (This : in Predictions_Cluster) return Boolean is
   begin
      return Local_Loading.Has_Space (Cluster_Base (This));
   end Has_Space;

   procedure Load (This             : in out Predictions_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
      use Local_Loading;
   begin
      Load (Cluster_Base (This), Rule_Storage_Ptr, This.Last_Loaded);
   end Load;

end Nomo.Interpreter.Predictions_Clusters.Loading;
