--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>


with Nomo.Numerics.Times;

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Internal_Events_Index;

with Nomo.Interpreter.Plant.Chunks_Index;

with Nomo.Interpreter.Plant.Targets;

with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Plant.Internal_Pointers_Register is

   procedure Cancel;
   pragma Inline (Cancel);

   use Internal_Events_Index;
   use Chunks_Index;

   function Get_Event_Position (I : in Internal_Chunk_Index) return Internal_Event_Index;
   pragma Inline (Get_Event_Position);


   use Types_Index.Ranges;

   function Get_Type_Index (I : in Internal_Chunk_Index) return Internal_Type_Index;
   pragma Inline (Get_Type_Index);

   use Targets;

   procedure Get_Target (I            : in Internal_Chunk_Index;
                         Chunk_Target : out Target);
   pragma Inline (Get_Target);

   use Numerics.Times;

   function Is_Expired (I : in Internal_Chunk_Index;
                        T : in Positive_Time) return Boolean;
   pragma Inline (Is_Expired);

   use Numerics.Informations;

   procedure Set_Scope (I           : in Internal_Chunk_Index;
                        Information : in Positive_Integer);

   procedure Update_Positions (T : in Positive_Time);

end Nomo.Interpreter.Plant.Internal_Pointers_Register;
