--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Internal_Pointers;

package body Nomo.Interpreter.Plant.Internal_Pointers_Register is

 use Internal_Pointers;

   Pointers : array (Internal_Chunk_Index'Range) of Internal_Pointer;
   Register : array (Internal_Chunk_Index'Range) of Internal_Chunk_Index;
   Pointer_Last : Positive := 1;

   procedure Cancel is
   begin
      Pointer_Last := 1;
   end Cancel;

   function Get_Event_Position (I : in Internal_Chunk_Index) return Internal_Event_Index is
   begin
      return Pointers (I).Get_Event_Position;
   end Get_Event_Position;

   function Get_Type_Index (I : in Internal_Chunk_Index) return Internal_Type_Index is
   begin
       return Pointers (I).Get_Type_Index;
   end Get_Type_Index;

   procedure Get_Target (I            : in Internal_Chunk_Index;
                         Chunk_Target : out Target) is
   begin
      Pointers (I).Get_Target (Chunk_Target);
   end Get_Target;

   function Is_Expired (I : in Internal_Chunk_Index;
                        T : in Positive_Time) return Boolean is
   begin
      return Pointers (I).Is_Expired (T);
   end Is_Expired;

   procedure Set_Scope (I           : in Internal_Chunk_Index;
                        Information : in Positive_Integer) is
   begin
      Pointers (I).Set_Scope (Information);
      Pointer_Last := Pointer_Last + 1;
      Register (Chunk_Index (Pointer_Last)) := I;
   end Set_Scope;

   procedure Update_Positions (T : in Positive_Time) is
   begin
      for I in Register'First .. Chunk_Index (Pointer_Last) loop
         Pointers (Register (I)).Update_Position (T);
      end loop;
      Pointer_Last := 1;
   end Update_Positions;

end Nomo.Interpreter.Plant.Internal_Pointers_Register;
