--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Event_Memory.Internal.Plant;

package body Nomo.Interpreter.Plant.Internal_Pointers is

   function Get_Event_Position (This : in Internal_Pointer) return Internal_Event_Index is
   begin
      return This.Event_Position;
   end Get_Event_Position;

   function Get_Type_Index (This : in Internal_Pointer) return Internal_Type_Index is
   begin
      return This.Index;
   end Get_Type_Index;

   procedure Get_Target (This          : in Internal_Pointer;
                         Chunck_Target : out Target) is
   begin
      Chunck_Target.Capture_Time := This.Capture_Time;
      Chunck_Target.Arrival_Time := This.Arrival_Time;
      Chunck_Target.Index := This.Index;
   end Get_Target;

   function Is_Expired (This : in Internal_Pointer;
                        T    : in Positive_Time) return Boolean is
   begin
      return Target (This).Is_Expired (T);
   end Is_Expired;

   procedure Set_Scope (This        : out Internal_Pointer;
                        Information : in Positive_Integer) is
   begin
      This.Scope_Index := Positive(Information);
   end Set_Scope;

   procedure Update_Position (This : in out Internal_Pointer;
                              T    : in Positive_Time) is
      use Event_Memory.Internal.Plant;
   begin
      This.Capture_Time := T;
      Get_Current_Event (This.Scope_Index, This.Index, This.Event_Position, This.Arrival_Time);

   end Update_Position;

end Nomo.Interpreter.Plant.Internal_Pointers;
