--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Internal_Events_Index;

with Nomo.Interpreter.Plant.Chunks_Index;

private with Nomo.Interpreter.Plant.Targets;

private with Nomo.Internal_Messages;

private package Nomo.Interpreter.Plant.Internal_Chunks is

   type Internal_Chunk is tagged limited private;

   use Numerics.Times;
   use Chunks_Index;

   procedure Assume (This    : in out Internal_Chunk;
                     T       : in Positive_Time;
                     Pointer : in Internal_Chunk_Index);

   procedure Assume_With_Target (This         : in out Internal_Chunk;
                                 Pointer      : in Internal_Chunk_Index;
                                 Target_Chunk : in Internal_Chunk);

   use Types_Index.Ranges;

   procedure Create_Perception_Forward (This         : in out Internal_Chunk;
                                        Capture_Time : in Positive_Time;
                                        Arrival_Time : in Positive_Time;
                                        Input_Index  : in Input_Type_Index);

   function Get_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_Arrival_Time);

   function Get_Arrival_Time (This      : in Internal_Chunk;
                              Operation : in Positive) return Positive_Time;

   function Get_Capture_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_Capture_Time);

   function Get_Before_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_Before_Arrival_Time);

   function Get_First_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_First_Arrival_Time);

   function Get_Last_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_Last_Arrival_Time);

   function Get_After_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_After_Arrival_Time);

   function Get_Same_Arrival_Time (This : in Internal_Chunk) return Positive_Time;
   pragma Inline (Get_Same_Arrival_Time);

   function Get_Operation (This : in Internal_Chunk) return Positive;
   pragma Inline (Get_Operation);

   --  L'item est expir si le message qu'il contient l'est.
   function Is_Expired (This : in Internal_Chunk;
                        T    : in Positive_Time) return Boolean;
   pragma Inline (Is_Expired);

   procedure Send_In_Conclusion (This         : in Internal_Chunk;
                                 Is_Reference : in Boolean);
   pragma Inline (Send_In_Conclusion);

   procedure Send_In_Excitatory_Condition (This : in Internal_Chunk);
   pragma Inline (Send_In_Excitatory_Condition);

   procedure Send_In_Inhibitory_Condition (This : in Internal_Chunk);
   pragma Inline (Send_In_Inhibitory_Condition);

   use Internal_Events_Index;

   procedure Set_Event_Position (This     : out Internal_Chunk;
                                 Position : in Internal_Event_Index);
   pragma Inline (Set_Event_Position);

   procedure Set_Operation (This      : out Internal_Chunk;
                            Operation : in Positive);
   pragma Inline (Set_Operation);

   procedure Set_Temporal_Reference (This                    : in Internal_Chunk;
                                     Is_Reference_And_Origin : in Boolean);

private

   use Targets;
   use Internal_Messages;

   type Internal_Chunk is limited new Target with record
      Operation      : Positive;
      Data           : Internal_Message;
      Event_Position : Internal_Event_Index;
   end record;

end Nomo.Interpreter.Plant.Internal_Chunks;
